/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.TypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeRegistryImpl
implements TypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeRegistryImpl.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final long id;
    private final Map<Integer, Type> definitions;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    TypeRegistryImpl() {
        this.id = COUNTER.incrementAndGet();
        this.definitions = new HashMap<Integer, Type>();
    }

    protected final long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void update(Map<Integer, Type> definitions) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<Integer, Type> entry : definitions.entrySet()) {
                Type result = this.definitions.put(entry.getKey(), entry.getValue());
                if (!LOGGER.isTraceEnabled() || result != null) continue;
                LOGGER.trace(String.format("Added type '%s' to TypeRegistry(%d)", entry.getValue(), this.getId()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(Class<?> clazz, Type type) {
        this.lock.writeLock().lock();
        try {
            boolean result;
            int key = System.identityHashCode(clazz);
            boolean bl = result = !this.definitions.containsKey(key);
            if (result) {
                this.definitions.put(key, type);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("Registered type '%s' for class '%s' in TypeRegistry(%d)", type.getNamespace() + type.getName(), clazz, this.getId()));
                }
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregister(Class<?> clazz) {
        this.lock.writeLock().lock();
        try {
            this.definitions.remove(System.identityHashCode(clazz));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type lookup(Class<?> clazz) {
        this.lock.readLock().lock();
        try {
            Type type = this.definitions.get(System.identityHashCode(clazz));
            return type;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter(result);
        out.printf("TypeRegistryImpl(%d) {%n", this.getId());
        out.printf("\tDefinitions {", new Object[0]);
        for (Map.Entry<Integer, Type> entry : this.definitions.entrySet()) {
            out.printf("%n\t\t%s", entry.getValue());
        }
        out.printf("%n\t}%n", new Object[0]);
        out.printf("}%n", new Object[0]);
        return result.toString();
    }

    protected final ReadWriteLock getLock() {
        return this.lock;
    }

    protected final Map<Integer, Type> getDefinitions() {
        return this.definitions;
    }
}

