/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ldp4j.rdf.Literal;
import org.ldp4j.rdf.Node;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.Triple;
import org.ldp4j.rdf.URIRef;
import org.ldp4j.rdf.bean.Cardinality;
import org.ldp4j.rdf.bean.Category;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.NamingPolicy;
import org.ldp4j.rdf.bean.Property;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.impl.TransactionalTypeRegistry;
import org.ldp4j.rdf.bean.impl.TypeManager;
import org.ldp4j.rdf.bean.impl.TypeManagerImpl;
import org.ldp4j.rdf.bean.impl.TypeProcessor;
import org.ldp4j.rdf.bean.impl.TypeSupport;
import org.ldp4j.rdf.bean.impl.model.Graph;
import org.ldp4j.rdf.bean.impl.model.Individual;
import org.ldp4j.rdf.bean.impl.model.ModelFactory;
import org.ldp4j.rdf.util.RDFModelDSL;
import org.ldp4j.rdf.util.TripleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TypeProcessorImpl<T>
implements TypeProcessor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeProcessorImpl.class);
    private final Class<? extends T> clazz;
    private final TransactionalTypeRegistry registry;

    TypeProcessorImpl(Class<? extends T> clazz, TransactionalTypeRegistry registry) {
        this.clazz = clazz;
        this.registry = registry;
    }

    private static void log(String format, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format(format, args));
        }
    }

    @Override
    public TripleSet deflate(T o, NamingPolicy policy) {
        TransactionalTypeRegistry savepoint = this.registry.setSavepoint();
        try {
            MarshallingSession session = new MarshallingSession(policy, new TypeManagerImpl(savepoint));
            Marshaller newMarshaller = session.newMarshaller(o);
            newMarshaller.marshall();
            TripleSet result = session.getTriples();
            savepoint.commit();
            return result;
        }
        catch (InvalidDefinitionException e) {
            savepoint.rollback();
            throw e;
        }
    }

    @Override
    public T inflate(Resource<?> identity, TripleSet triples) {
        TransactionalTypeRegistry savepoint = this.registry.setSavepoint();
        try {
            UnmarshallingSession context = new UnmarshallingSession(new TypeManagerImpl(savepoint), triples);
            Unmarshaller newUnmarshaller = context.newUnmarshaller(this.clazz);
            Object result = newUnmarshaller.unmarshall(identity);
            savepoint.commit();
            return result;
        }
        catch (InvalidDefinitionException e) {
            savepoint.rollback();
            throw e;
        }
    }

    private static class Marshaller<T> {
        private static final URIRef RDF_TYPE = RDFModelDSL.uriRef((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        private final T source;
        private final List<Type> types;
        private final MarshallingSession session;

        Marshaller(T source, List<Type> types, MarshallingSession session) {
            this.source = source;
            this.types = types;
            this.session = session;
        }

        private void logTriple(Object subject, Object predicate, Object object) {
            TypeProcessorImpl.log("-> Triple {%08X, %s, %s}", new Object[]{System.identityHashCode(subject), predicate, object});
        }

        private Collection<?> getValues(Property property) {
            Object value = property.getValue(this.source);
            ArrayList<Object> values = null;
            if (value instanceof Collection) {
                values = (ArrayList<Object>)value;
            } else {
                ArrayList<Object> tmp = new ArrayList<Object>();
                if (value != null) {
                    tmp.add(value);
                }
                values = tmp;
            }
            return values;
        }

        private void marshallProperty(Resource<?> subject, URIRef predicate, Object value) {
            Resource<?> object = null;
            PropertyType propertyType = null;
            if (TypeSupport.isLiteral(value.getClass())) {
                propertyType = PropertyType.LITERAL;
                object = RDFModelDSL.literal((Object)value);
            } else {
                propertyType = PropertyType.OBJECT;
                object = this.resolve(value);
            }
            TypeProcessorImpl.log("Adding %s property '%s' to object '%s'...", new Object[]{propertyType, predicate, this.source});
            this.logTriple(this.source, predicate, object);
            this.session.addTriple(subject, predicate, object);
        }

        private Resource<?> resolve(Object value) {
            Resource identity = this.session.lookup(value);
            if (identity == null) {
                TypeProcessorImpl.log("Paused marshalling of object '%s'.", new Object[]{this.source});
                Marshaller marshaller = this.session.newMarshaller(value);
                marshaller.marshall();
                TypeProcessorImpl.log("Resuming marshalling of object '%s'...", new Object[]{this.source});
                identity = this.session.lookup(value);
            }
            return identity;
        }

        void marshall() {
            Resource subject = this.session.lookup(this.source);
            if (subject != null) {
                return;
            }
            TypeProcessorImpl.log("Started marshalling of object '%s' with %s...", new Object[]{this.source, this.types});
            Type mainType = this.types.get(0);
            subject = mainType.getCategory().equals((Object)Category.ENUMERATION) ? this.session.deployEnumerated(this.source) : this.session.deploy(this.source);
            TypeProcessorImpl.log("Identified object '%s' as resource '%s'", new Object[]{this.source, subject});
            for (Type type : this.types) {
                this.addType(subject, type);
                for (Property property : type.getProperties()) {
                    Collection<?> values = this.getValues(property);
                    for (Object value : values) {
                        this.marshallProperty(subject, this.toURIRef(property), value);
                    }
                }
            }
            TypeProcessorImpl.log("Completed marshalling of object '%s'.", new Object[]{this.source});
        }

        private URIRef toURIRef(Property property) {
            return RDFModelDSL.uriRef((String)(property.getNamespace() + property.getName()));
        }

        private void addType(Resource<?> identity, Type type) {
            URIRef object = RDFModelDSL.uriRef((String)(type.getNamespace() + type.getName()));
            TypeProcessorImpl.log("Adding type '%s' to object '%s'...", new Object[]{object, this.source});
            this.logTriple(this.source, RDF_TYPE, object);
            this.session.addTriple(identity, Marshaller.RDF_TYPE, (Node)object);
        }

        private static enum PropertyType {
            LITERAL("datatype"),
            OBJECT("object");

            private final String description;

            private PropertyType(String description) {
                this.description = description;
            }

            public String toString() {
                return this.description;
            }
        }
    }

    private static final class MarshallingSession {
        private final NamingPolicy policy;
        private final Map<Integer, Resource<?>> o2r = new HashMap();
        private final TripleSet triples;
        private final TypeManager manager;

        private MarshallingSession(NamingPolicy policy, TypeManager manager) {
            this.policy = policy;
            this.manager = manager;
            this.triples = new TripleSet();
        }

        private <T> Marshaller<T> newMarshaller(T object) {
            List<Type> types = this.manager.getTypes(object.getClass());
            return new Marshaller<T>(object, types, this);
        }

        private <T> Resource<?> lookup(T object) {
            return this.o2r.get(System.identityHashCode(object));
        }

        private <T> Resource<?> deploy(T object) {
            Resource<?> resource = this.policy.createIdentity(object);
            this.o2r.put(System.identityHashCode(object), resource);
            return resource;
        }

        private <T> Resource<?> deployEnumerated(T object) {
            Resource<?> resource = this.policy.enumeratedIdentity(object);
            this.o2r.put(System.identityHashCode(object), resource);
            return resource;
        }

        private void addTriple(Resource<?> subject, URIRef predicate, Node object) {
            this.triples.add(subject, predicate, object);
        }

        private TripleSet getTriples() {
            return this.triples;
        }
    }

    private static class Unmarshaller<T> {
        private final Class<? extends T> clazz;
        private final UnmarshallingSession session;
        private List<Type> types;

        Unmarshaller(Class<? extends T> clazz, List<Type> types, UnmarshallingSession session) {
            this.clazz = clazz;
            this.types = types;
            this.session = session;
        }

        T unmarshall(Resource<?> identity) {
            Individual individual;
            Object result = this.session.resolve(this.clazz, identity);
            if (result != null && (individual = this.session.getIndividual(identity)) != null) {
                result = this.createBean(identity, individual);
            }
            return (T)result;
        }

        private T createBean(Resource<?> identity, Individual individual) {
            try {
                TypeProcessorImpl.log("Started unmarshalling of resource '%s' with %s...", new Object[]{identity, this.types});
                T bean = this.clazz.newInstance();
                this.session.register(bean, identity);
                TypeProcessorImpl.log("Registered object '%s' for resource '%s'", new Object[]{bean, identity});
                for (Type type : this.types) {
                    for (Property property : type.getProperties()) {
                        this.populateProperty(property, this.createProcessor(individual, property), bean);
                    }
                }
                TypeProcessorImpl.log("Completed unmarshalling of resource '%s'.", new Object[]{identity});
                return bean;
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        private ValueProcessor<?> createProcessor(Individual individual, Property property) {
            ValueProcessor<Object> processor = null;
            processor = property.getRange().isLiteral() ? new LiteralProcessor(individual) : new ObjectProcessor(individual);
            return processor;
        }

        private <S> Set<S> newSet(Class<? extends S> type) {
            return new HashSet();
        }

        private <S> List<S> newList(Class<? extends S> type) {
            return new ArrayList();
        }

        private <S> void populateProperty(Property property, ValueProcessor<S> handler, T target) {
            List<S> values = handler.getValues(property);
            int max = this.enforceCardinalityRestrictions(property, values);
            Class<?> range = property.getRange().getType();
            if (!values.isEmpty()) {
                if (max == 1) {
                    S value = values.get(0);
                    Object bean = handler.processValue(value, range);
                    property.setValue(target, bean);
                    TypeProcessorImpl.log("-> Property(%s)=%s", new Object[]{property.getName(), bean});
                } else {
                    Collection<?> collection = !property.getCardinality().allowsRepetitions() ? this.newSet(range) : this.newList(range);
                    for (int i = 0; i < max; ++i) {
                        S value = values.get(i);
                        Object bean = handler.processValue(value, range);
                        collection.add(bean);
                    }
                    property.setValue(target, collection);
                    TypeProcessorImpl.log("-> Property(%s)=%s", new Object[]{property.getName(), collection});
                }
            }
        }

        private static URIRef predicate(Property property) {
            return RDFModelDSL.uriRef((String)(property.getNamespace() + property.getName()));
        }

        private int enforceCardinalityRestrictions(Property property, List<?> values) {
            int max;
            Cardinality cardinality = property.getCardinality();
            int min = cardinality.min();
            int n = max = cardinality.isUnbounded() ? values.size() : cardinality.max();
            if (min > values.size()) {
                throw new IllegalStateException("Not enough values defined for property '" + Unmarshaller.predicate(property) + "': expected " + min + " but got " + values.size());
            }
            if (max < values.size()) {
                throw new IllegalStateException("Defined more values than required for property '" + Unmarshaller.predicate(property) + "': expected " + max + " but got " + values.size());
            }
            return max;
        }

        private static class LiteralProcessor
        implements ValueProcessor<Object> {
            private final Individual individual;

            private LiteralProcessor(Individual individual) {
                this.individual = individual;
            }

            @Override
            public List<Object> getValues(Property property) {
                ArrayList<Object> links = new ArrayList<Object>();
                for (Literal<?> literal : this.individual.getPropertyValues(Unmarshaller.predicate(property))) {
                    links.add(literal.getValue());
                }
                return links;
            }

            @Override
            public <S> S processValue(Object value, Class<? extends S> clazz) {
                if (!clazz.isAssignableFrom(value.getClass())) {
                    throw new IllegalStateException("Invalid type: expected an instance of '" + clazz.getCanonicalName() + "' but got an instance of '" + value.getClass().getCanonicalName() + "'");
                }
                return clazz.cast(value);
            }
        }

        private class ObjectProcessor
        implements ValueProcessor<Individual> {
            private final Individual individual;

            private ObjectProcessor(Individual individual) {
                this.individual = individual;
            }

            @Override
            public List<Individual> getValues(Property property) {
                ArrayList<Individual> links = new ArrayList<Individual>();
                for (Individual literal : this.individual.getPropertyObjects(Unmarshaller.predicate(property))) {
                    links.add(literal);
                }
                return links;
            }

            @Override
            public <S> S processValue(Individual value, Class<? extends S> clazz) {
                return this.resolve(value, clazz, this.individual.getIdentity());
            }

            private <S> S resolve(Individual individual, Class<? extends S> type, Resource<?> source) {
                Object bean = Unmarshaller.this.session.resolve(type, individual.getIdentity());
                if (bean == null) {
                    TypeProcessorImpl.log("Paused unmarshalling of resource '%s'.", new Object[]{source});
                    Unmarshaller marshaller = Unmarshaller.this.session.newUnmarshaller(type);
                    bean = marshaller.unmarshall(individual.getIdentity());
                    TypeProcessorImpl.log("Resuming unmarshalling of resource '%s'...", new Object[]{source});
                }
                return (S)bean;
            }
        }

        private static interface ValueProcessor<T> {
            public List<T> getValues(Property var1);

            public <S> S processValue(T var1, Class<? extends S> var2);
        }
    }

    private static final class UnmarshallingSession {
        private final Map<Integer, Object> r2o = new HashMap<Integer, Object>();
        private final TripleSet triples;
        private final TypeManager manager;
        private final Graph graph;

        private UnmarshallingSession(TypeManager manager, TripleSet triples) {
            this.manager = manager;
            this.triples = triples;
            this.graph = ModelFactory.newGraph((Iterable<Triple>)this.getTriples());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Created unmarshalling session for: \n" + this.graph);
            }
        }

        private <T> Unmarshaller<T> newUnmarshaller(Class<? extends T> clazz) {
            List<Type> types = this.manager.getTypes(clazz);
            return new Unmarshaller<T>(clazz, types, this);
        }

        private TripleSet getTriples() {
            return this.triples;
        }

        private <T> T resolve(Class<? extends T> clazz, Resource<?> resource) {
            Type lookup = this.manager.getRegistry().lookup(clazz);
            if (lookup.getCategory().equals((Object)Category.ENUMERATION)) {
                throw new UnsupportedOperationException("Method not implemented yet");
            }
            Object object = this.r2o.get(System.identityHashCode(resource));
            if (clazz.isInstance(object)) {
                return clazz.cast(object);
            }
            return null;
        }

        private <T> void register(T object, Resource<?> resource) {
            this.r2o.put(System.identityHashCode(resource), object);
        }

        private Individual getIndividual(Resource<?> identity) {
            return this.graph.getIndividual(identity);
        }
    }
}

