/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.ArrayList;
import java.util.List;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.TypeRegistry;
import org.ldp4j.rdf.bean.impl.DefinitionLoader;
import org.ldp4j.rdf.bean.impl.TypeManager;

final class TypeManagerImpl
implements TypeManager {
    private final TypeRegistry registry;

    TypeManagerImpl(TypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public TypeRegistry getRegistry() {
        return new TypeRegistry(){

            @Override
            public boolean register(Class<?> clazz, Type type) {
                return TypeManagerImpl.this.registry.register(clazz, type);
            }

            @Override
            public Type lookup(Class<?> clazz) {
                return TypeManagerImpl.this.registry.lookup(clazz);
            }

            @Override
            public void deregister(Class<?> clazz) {
                TypeManagerImpl.this.registry.deregister(clazz);
            }
        };
    }

    @Override
    public boolean isType(Class<?> clazz) {
        return !this.getTypes(clazz).isEmpty();
    }

    @Override
    public List<Type> getTypes(Class<?> clazz) {
        ArrayList<Type> result = new ArrayList<Type>();
        this.collectTypes(clazz, result);
        return result;
    }

    private void collectTypes(Class<?> clazz, List<Type> result) {
        Class<?> c = clazz;
        while (c != null) {
            Class<?>[] interfaces;
            Type definition = DefinitionLoader.loadType(c, this);
            if (definition != null) {
                result.add(definition);
            }
            for (Class<?> i : interfaces = c.getInterfaces()) {
                this.collectTypes(i, result);
            }
            if ((c = c.getSuperclass()) != Object.class) continue;
            c = null;
        }
    }
}

