/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.ldp4j.rdf.bean.Category;
import org.ldp4j.rdf.bean.Property;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.impl.EnumerationHelper;

final class TypeDefinition
implements Type {
    private final String name;
    private final String namespace;
    private final Class<?> target;
    private final Category category;
    private final AtomicReference<List<Property>> properties;
    private EnumerationHelper<?> helper = null;

    TypeDefinition(String name, String namespace, Category category, Class<?> target) {
        this.name = name;
        this.namespace = namespace;
        this.category = category;
        this.target = target;
        this.properties = new AtomicReference(TypeDefinition.safeCopy(Collections.emptyList()));
    }

    private static <T> List<T> safeCopy(List<T> source) {
        return Collections.unmodifiableList(new ArrayList<T>(source));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties.get();
    }

    @Override
    public Class<?> getBound() {
        return this.target;
    }

    public String toString() {
        return String.format("TypeDefinition {name=%s, namespace=%s, category=%s, bound=%s}", new Object[]{this.name, this.namespace, this.category, this.target.getCanonicalName()});
    }

    private void setProperties(List<Property> properties) {
        if (properties != null) {
            this.properties.set(TypeDefinition.safeCopy(properties));
        }
    }

    private EnumerationHelper<?> getHelper() {
        return this.helper;
    }

    private void setHelper(EnumerationHelper<?> helper) {
        this.helper = helper;
    }

    static void initiliazeProperties(TypeDefinition definition, List<Property> properties) {
        definition.setProperties(properties);
    }

    static void setHelper(TypeDefinition definition, EnumerationHelper<?> helper) {
        definition.setHelper(helper);
    }

    static EnumerationHelper<?> getHelper(TypeDefinition definition) {
        return definition.getHelper();
    }
}

