/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.impl.TypeRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransactionalTypeRegistry
extends TypeRegistryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalTypeRegistry.class);
    private TransactionalTypeRegistry original;
    private final Map<Integer, Type> newDefinitions = new HashMap<Integer, Type>();

    TransactionalTypeRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(Class<?> clazz, Type type) {
        this.getLock().writeLock().lock();
        try {
            boolean result = super.register(clazz, type);
            if (result) {
                this.newDefinitions.put(System.identityHashCode(clazz), type);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionalTypeRegistry setSavepoint() {
        this.getLock().readLock().lock();
        try {
            TransactionalTypeRegistry copy = new TransactionalTypeRegistry();
            copy.update(this.getDefinitions());
            copy.update(this.newDefinitions);
            copy.original = this;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Created savepoint for TypeRegistry(%d)", this.getId()));
            }
            TransactionalTypeRegistry transactionalTypeRegistry = copy;
            return transactionalTypeRegistry;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() {
        this.getLock().writeLock().lock();
        try {
            if (this.original != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("Rolled back savepoint for TypeRegistry(%d)", this.original.getId()));
                }
                this.original = null;
                this.newDefinitions.clear();
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() {
        this.getLock().writeLock().lock();
        try {
            if (!this.newDefinitions.isEmpty() && this.original != null) {
                this.original.update(this.newDefinitions);
                this.original.commit();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("Commited savepoint for TypeRegistry(%d)", this.original.getId()));
                }
                this.original = null;
                this.newDefinitions.clear();
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter(result);
        out.printf("TransactionalTypeRegistryImpl(%d) {%n", this.getId());
        out.printf("\tDefinitions {", new Object[0]);
        for (Map.Entry<Integer, Type> entry : this.newDefinitions.entrySet()) {
            out.printf("%n\t\t%s", entry.getValue());
        }
        out.printf("%n\t}%n", new Object[0]);
        out.printf("}%n", new Object[0]);
        return result.toString();
    }
}

