/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.Range;
import org.ldp4j.rdf.bean.impl.RangeDefinition;
import org.ldp4j.rdf.bean.impl.TypeManager;
import org.ldp4j.rdf.bean.impl.TypeSupport;

final class RangeExtractor {
    private final RangeValidator validator;
    private RangeDefinition range;

    RangeExtractor(TypeManager typeManager) {
        this.validator = new RangeValidator(typeManager);
    }

    private boolean isValidClass(Type type) {
        boolean result = false;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            result = this.validator.isValid(clazz);
            if (result) {
                this.range = new RangeDefinition();
                this.range.setType(clazz);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            result = this.isValidClass(pt.getRawType());
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type[] bounds = typeVariable.getBounds();
            for (int i = 0; i < bounds.length && !result; ++i) {
                result = this.isValidClass(typeVariable.getBounds()[i]);
            }
        }
        if (result) {
            this.range.setGenericType(type);
        }
        return result;
    }

    private boolean isValidAggregation(Type type) {
        ParameterizedType pt;
        boolean result = false;
        if (type instanceof ParameterizedType && (result = TypeSupport.isAggregation((Class)(pt = (ParameterizedType)type).getRawType()))) {
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            result = this.isValidClass(actualTypeArguments[0]);
        }
        return result;
    }

    private boolean isValid(Type type) {
        return this.isValidAggregation(type) || this.isValidClass(type);
    }

    Range getRange(Type type) {
        if (!this.isValid(type)) {
            throw new InvalidDefinitionException("Unsupported range type '" + type + "'");
        }
        return this.range;
    }

    private static class RangeValidator {
        private final TypeManager typeManager;

        private RangeValidator(TypeManager typeManager) {
            this.typeManager = typeManager;
        }

        private boolean isValid(Class<?> clazz) {
            boolean valid = TypeSupport.isLiteral(clazz);
            if (!valid) {
                valid = this.typeManager.isType(clazz);
            }
            return valid;
        }
    }
}

