/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.Property;
import org.ldp4j.rdf.bean.impl.PropertyFactory;
import org.ldp4j.rdf.bean.impl.TypeManager;
import org.ldp4j.rdf.bean.util.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyScanner.class);
    private final Class<?> clazz;
    private final String defaultNamespace;

    PropertyScanner(Class<?> clazz, String defaultNamespace) {
        this.clazz = clazz;
        this.defaultNamespace = defaultNamespace;
    }

    List<Property> getProperties(TypeManager typeManager) {
        Scanner scanner = new Scanner(typeManager);
        if (!scanner.isValid()) {
            throw new InvalidDefinitionException(scanner.getReport());
        }
        return scanner.getDefinitions();
    }

    private class Scanner {
        private List<Property> definitions = new ArrayList<Property>();
        private Map<String, String> violations = new HashMap<String, String>();
        private final PropertyFactory factory;

        private Scanner(TypeManager typeManager) {
            this.factory = new PropertyFactory(PropertyScanner.this.defaultNamespace, typeManager);
        }

        boolean isValid() {
            this.scanMethods();
            this.scanFields();
            return this.violations.isEmpty();
        }

        private void scanMethods() {
            LOGGER.trace("- Class: {}", (Object)PropertyScanner.this.clazz.getCanonicalName());
            for (Method method : PropertyScanner.this.clazz.getDeclaredMethods()) {
                Class<?> declaringClass;
                if (LOGGER.isTraceEnabled() && (declaringClass = method.getDeclaringClass()) != Object.class) {
                    LOGGER.trace("\t+ Method: {}", (Object)method.getName());
                    LOGGER.trace("\t\t- Declaring class: {}", (Object)declaringClass.getCanonicalName());
                    LOGGER.trace("\t\t- Local: {}", (Object)(PropertyScanner.this.clazz == declaringClass ? 1 : 0));
                    LOGGER.trace("\t\t- Return: {} ({})", (Object)method.getReturnType().getCanonicalName(), (Object)TypeUtils.toString(method.getGenericReturnType()));
                }
                if (!this.factory.isAnnotated(method)) continue;
                this.scanMethod(method);
            }
        }

        private void scanMethod(Method method) {
            try {
                Property property = this.factory.createDefinition(method);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Created property: " + property);
                }
                this.definitions.add(property);
            }
            catch (InvalidDefinitionException e) {
                this.addViolation(method, e);
            }
        }

        private void addViolation(Member member, Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                String type = "field";
                if (member instanceof Method) {
                    type = "method";
                }
                LOGGER.debug("Found invalid " + type + "'" + member.getName() + "': " + e.getMessage());
            }
            this.violations.put(member.getName(), e.getMessage());
        }

        private void scanFields() {
            for (Field field : PropertyScanner.this.clazz.getDeclaredFields()) {
                this.makeAccessible(field);
                if (!this.factory.isAnnotated(field)) continue;
                this.scanField(field);
            }
        }

        private void scanField(Field field) {
            try {
                Property property = this.factory.createDefinition(field);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Created property: " + property);
                }
                this.definitions.add(property);
            }
            catch (InvalidDefinitionException e) {
                this.addViolation(field, e);
            }
        }

        private void makeAccessible(final Field field) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        field.setAccessible(true);
                        return null;
                    }
                    catch (SecurityException e) {
                        throw new IllegalStateException(String.format("Field '%s' in class '%s' cannot be accessed", field.getName(), PropertyScanner.this.clazz.getName()), e);
                    }
                }
            });
        }

        public List<Property> getDefinitions() {
            return this.definitions;
        }

        public String getReport() {
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            out.printf("Property definition violations found (%d):", this.violations.size());
            for (Map.Entry<String, String> violation : this.violations.entrySet()) {
                out.printf("%n\t- %s (%s)", violation.getValue(), violation.getKey());
            }
            return result.toString();
        }
    }
}

