/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.ldp4j.rdf.bean.Cardinality;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.Property;
import org.ldp4j.rdf.bean.PropertyEditor;
import org.ldp4j.rdf.bean.Range;
import org.ldp4j.rdf.bean.annotations.CardinalityConstraint;
import org.ldp4j.rdf.bean.impl.CardinalityDefinition;
import org.ldp4j.rdf.bean.impl.PropertyDefinition;
import org.ldp4j.rdf.bean.impl.PropertyDescriptor;
import org.ldp4j.rdf.bean.impl.PropertyScanner;
import org.ldp4j.rdf.bean.impl.RangeExtractor;
import org.ldp4j.rdf.bean.impl.StringUtils;
import org.ldp4j.rdf.bean.impl.TypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyScanner.class);
    private final TypeManager typeManager;
    private final String defaultNamespace;

    PropertyFactory(String defaultNamespace, TypeManager typeManager) {
        this.defaultNamespace = defaultNamespace;
        this.typeManager = typeManager;
    }

    boolean isAnnotated(AnnotatedElement element) {
        return element.isAnnotationPresent(org.ldp4j.rdf.bean.annotations.Property.class);
    }

    <T extends AnnotatedElement & Member> Property assemble(T member, PropertyDescriptor descriptor) {
        return new PropertyDefinitionBuilder().withAnnotatedMember(member).forDescriptor(descriptor);
    }

    Property createDefinition(Method getter) {
        assert (this.isAnnotated(getter)) : "Method '" + getter + "' is not annotated with '" + Property.class + "'";
        PropertyDescriptor.MethodPropertyDescriptor descriptor = PropertyDescriptor.newDescriptor(getter);
        PropertyFactory.verifyGetterModifiers(getter);
        PropertyFactory.verifyGetterCompliance(getter);
        PropertyFactory.verifyPropertyWritability(PropertyDescriptor.getPropertyWriter(descriptor));
        return this.assemble(getter, descriptor);
    }

    Property createDefinition(Field field) {
        assert (this.isAnnotated(field)) : "Field '" + field + "' is not annotated with '" + Property.class + "'";
        PropertyDescriptor.FieldPropertyDescriptor descriptor = PropertyDescriptor.newDescriptor(field);
        PropertyFactory.verifyPropertyWritability(field);
        return this.assemble(field, descriptor);
    }

    private Range getPropertyRange(Type type) {
        return new RangeExtractor(this.typeManager).getRange(type);
    }

    private static void fail(String message, Object ... args) {
        throw new InvalidDefinitionException(String.format(message, args));
    }

    private static void verifyGetterModifiers(Method getter) {
        int modifiers = getter.getModifiers();
        PropertyFactory.assertGetterIsNotPrivate(modifiers);
        PropertyFactory.assertGetterIsNotProtected(modifiers);
        PropertyFactory.assertGetterIsNotAbstract(modifiers);
        PropertyFactory.assertGetterIsNotStatic(modifiers);
    }

    private static void verifyGetterCompliance(Method getter) {
        String methodName = getter.getName();
        boolean booleanGetter = PropertyFactory.assertGetterNameIsValid(methodName);
        PropertyFactory.assertGetterHasNoParameters(getter, methodName);
        PropertyFactory.assertGetterHasProperReturnType(getter, methodName, booleanGetter);
    }

    private static void verifyPropertyWritability(Method setter) {
        PropertyFactory.assertSetterExists(setter);
        int modifiers = setter.getModifiers();
        PropertyFactory.assertSetterIsNotPrivate(modifiers);
        PropertyFactory.assertSetterIsNotProtected(modifiers);
        PropertyFactory.assertSetterIsNotAbstract(modifiers);
        PropertyFactory.assertSetterIsNotStatic(modifiers);
    }

    private static void verifyPropertyWritability(Field field) {
        int modifiers = field.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            PropertyFactory.fail("Final fields cannot be annotated as '%s'", Property.class.getName());
        }
        if (Modifier.isStatic(modifiers)) {
            PropertyFactory.fail("Static fields cannot be annotated as '%s'", Property.class.getName());
        }
    }

    private static void assertGetterIsNotStatic(int modifiers) {
        if (Modifier.isStatic(modifiers)) {
            PropertyFactory.fail("Static methods cannot be annotated as '%s'", Property.class.getName());
        }
    }

    private static void assertGetterIsNotAbstract(int modifiers) {
        if (Modifier.isAbstract(modifiers)) {
            PropertyFactory.fail("Abstract methods cannot be annotated as '%s'", Property.class.getName());
        }
    }

    private static void assertGetterIsNotProtected(int modifiers) {
        if (Modifier.isProtected(modifiers)) {
            PropertyFactory.fail("Protected methods cannot be annotated as '%s'", Property.class.getName());
        }
    }

    private static void assertGetterIsNotPrivate(int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            PropertyFactory.fail("Private methods cannot be annotated as '%s'", Property.class.getName());
        }
    }

    private static void assertGetterHasProperReturnType(Method getter, String methodName, boolean booleanGetter) {
        Class<?> tmp = getter.getReturnType();
        if (tmp.equals(Void.TYPE) || tmp.equals(Void.class)) {
            PropertyFactory.fail("Only getter methods can be annotated as '%s': method '%s' does not return value", Property.class.getName(), methodName);
        }
        if (booleanGetter && !tmp.equals(Boolean.TYPE)) {
            PropertyFactory.fail("Only getter methods can be annotated as '%s': method '%s' should return a boolean value", Property.class.getName(), methodName);
        }
    }

    private static void assertGetterHasNoParameters(Method getter, String methodName) {
        if (getter.getParameterTypes().length != 0) {
            PropertyFactory.fail("Only getter methods can be annotated as '%s': method '%s' has parameters", Property.class.getName(), methodName);
        }
    }

    private static boolean assertGetterNameIsValid(String methodName) {
        boolean booleanGetter = PropertyFactory.isBooleanGetterName(methodName);
        if (!booleanGetter && !PropertyFactory.isNonBooleanGetterName(methodName)) {
            PropertyFactory.fail("Only methods following the getter naming convention can be annotated as '%s': found '%s'", Property.class.getName(), methodName);
        }
        return booleanGetter;
    }

    private static boolean isBooleanGetterName(String methodName) {
        return methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2));
    }

    private static boolean isNonBooleanGetterName(String methodName) {
        return methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3));
    }

    private static void assertSetterIsNotStatic(int modifiers) {
        if (Modifier.isStatic(modifiers)) {
            PropertyFactory.fail("Setter method cannot be static", new Object[0]);
        }
    }

    private static void assertSetterIsNotAbstract(int modifiers) {
        if (Modifier.isAbstract(modifiers)) {
            PropertyFactory.fail("Setter method cannot be abstract", new Object[0]);
        }
    }

    private static void assertSetterIsNotProtected(int modifiers) {
        if (Modifier.isProtected(modifiers)) {
            PropertyFactory.fail("Setter method cannot be protected", new Object[0]);
        }
    }

    private static void assertSetterIsNotPrivate(int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            PropertyFactory.fail("Setter method cannot be private", new Object[0]);
        }
    }

    private static void assertSetterExists(Method setter) {
        if (setter == null) {
            PropertyFactory.fail("Property cannot be written", new Object[0]);
        }
    }

    private class PropertyDefinitionBuilder {
        private org.ldp4j.rdf.bean.annotations.Property property;
        private String defaultName;
        private Class<?> domain;
        private Range range;
        private Cardinality cardinality;
        private List<Annotation> cardinalityConstraints;

        private PropertyDefinitionBuilder() {
        }

        private Property assemble(PropertyEditor editor) {
            String name = StringUtils.nonEmptyOrDefault(this.property.name(), this.defaultName);
            String namespace = StringUtils.nonEmptyOrDefault(this.property.namespace(), PropertyFactory.this.defaultNamespace);
            return new PropertyDefinition(name, namespace, this.domain, this.range, this.cardinality, editor);
        }

        private PropertyDefinitionBuilder withDefaultName(String name) {
            this.defaultName = name;
            return this;
        }

        private void dumpDescriptor(PropertyDescriptor descriptor) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Added property '%s' {class=%s, type=%s, editor=%s}", descriptor.getName(), descriptor.getPropertyType().getCanonicalName(), descriptor.getGenericPropertyType(), descriptor.getPropertyEditor()));
            }
        }

        <T extends AnnotatedElement & Member> PropertyDefinitionBuilder withAnnotatedMember(T element) {
            this.domain = ((Member)element).getDeclaringClass();
            this.property = element.getAnnotation(org.ldp4j.rdf.bean.annotations.Property.class);
            this.cardinalityConstraints = this.getCardinalityConstraints(element);
            return this;
        }

        private <T extends AnnotatedElement> List<Annotation> getCardinalityConstraints(T element) {
            Annotation[] annotations = element.getAnnotations();
            ArrayList<Annotation> constraints = new ArrayList<Annotation>();
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().isAnnotationPresent(CardinalityConstraint.class)) continue;
                constraints.add(annotation);
            }
            return constraints;
        }

        PropertyDefinitionBuilder withRange(Type type) {
            this.range = PropertyFactory.this.getPropertyRange(type);
            this.cardinality = CardinalityDefinition.fromConstraints(type, this.cardinalityConstraints);
            return this;
        }

        Property forDescriptor(PropertyDescriptor descriptor) {
            this.dumpDescriptor(descriptor);
            return this.withDefaultName(descriptor.getName()).withRange(descriptor.getGenericPropertyType()).assemble(descriptor.getPropertyEditor());
        }
    }
}

