/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.lang.reflect.Method;

final class PropertyDescriptorUtils {
    private PropertyDescriptorUtils() {
    }

    static String getName(Method method) {
        Class<?> resultType;
        String name = method.getName();
        if (name.startsWith("get")) {
            name = PropertyDescriptorUtils.decapitalize(name.substring(3));
        } else if (name.startsWith("is") && (resultType = method.getReturnType()) == Boolean.TYPE) {
            name = PropertyDescriptorUtils.decapitalize(name.substring(2));
        }
        return name;
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

