/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.ldp4j.rdf.bean.PropertyEditor;
import org.ldp4j.rdf.bean.impl.PropertyDescriptorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PropertyDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyDescriptor.class);
    private final String name;
    private final Class<?> propertyType;
    private final Type genericPropertyType;

    PropertyDescriptor(String name, Class<?> propertyType, Type genericPropertyType) {
        this.name = name;
        this.propertyType = propertyType;
        this.genericPropertyType = genericPropertyType;
    }

    String getName() {
        return this.name;
    }

    Class<?> getPropertyType() {
        return this.propertyType;
    }

    Type getGenericPropertyType() {
        return this.genericPropertyType;
    }

    abstract PropertyEditor getPropertyEditor();

    static MethodPropertyDescriptor newDescriptor(Method method) {
        return new MethodPropertyDescriptor(method);
    }

    static FieldPropertyDescriptor newDescriptor(Field field) {
        return new FieldPropertyDescriptor(field);
    }

    static Method getPropertyWriter(PropertyDescriptor descriptor) {
        assert (descriptor instanceof MethodPropertyDescriptor);
        return ((MethodPropertyDescriptor)descriptor).getWriteMethod();
    }

    private static final class FieldPropertyDescriptor
    extends PropertyDescriptor {
        private final Field field;

        private FieldPropertyDescriptor(Field field) {
            super(field.getName(), field.getType(), field.getGenericType());
            this.field = field;
        }

        @Override
        PropertyEditor getPropertyEditor() {
            return new FieldPropertyEditor(this.field);
        }

        private static final class FieldPropertyEditor
        implements PropertyEditor {
            private final Field field;

            public FieldPropertyEditor(Field field) {
                this.field = field;
            }

            @Override
            public Object getValue(Object subject) {
                try {
                    return this.field.get(subject);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public void setValue(Object subject, Object value) {
                try {
                    this.field.set(subject, value);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                return "Field {" + this.field + "}";
            }
        }
    }

    private static final class MethodPropertyDescriptor
    extends PropertyDescriptor {
        private final Method getter;
        private Method setter;
        private boolean tried;

        private MethodPropertyDescriptor(Method getter) {
            super(PropertyDescriptorUtils.getName(getter), getter.getReturnType(), getter.getGenericReturnType());
            this.getter = getter;
        }

        @Override
        PropertyEditor getPropertyEditor() {
            return new MethodPropertyEditor(this.getReadMethod(), this.getWriteMethod());
        }

        Method getReadMethod() {
            return this.getter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Method getWriteMethod() {
            Method method = this.getter;
            synchronized (method) {
                if (!this.tried) {
                    this.setter = this.findSetter();
                    this.tried = true;
                }
            }
            return this.setter;
        }

        private Method findSetter() {
            String setterName = "set" + this.capitalize(this.getName());
            try {
                return this.getter.getDeclaringClass().getDeclaredMethod(setterName, this.getPropertyType());
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchMethodException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("No setter for property '" + this.getName() + "' was found (" + e.getMessage() + ")", (Throwable)e);
                }
                return null;
            }
        }

        private String capitalize(String name) {
            if (name == null || name.length() == 0) {
                return name;
            }
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }

        private static final class MethodPropertyEditor
        implements PropertyEditor {
            private final Method getter;
            private final Method setter;

            public MethodPropertyEditor(Method getter, Method setter) {
                this.getter = getter;
                this.setter = setter;
            }

            @Override
            public Object getValue(Object subject) {
                try {
                    return this.getter.invoke(subject, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public void setValue(Object subject, Object value) {
                try {
                    this.setter.invoke(subject, value);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                return "Methods {getter=" + this.getter + ", setter=" + this.setter + "}";
            }
        }
    }
}

