/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.bean.JARBContext;
import org.ldp4j.rdf.bean.NamingPolicy;
import org.ldp4j.rdf.bean.impl.TransactionalTypeRegistry;
import org.ldp4j.rdf.bean.impl.TypeProcessor;
import org.ldp4j.rdf.bean.impl.TypeProcessorImpl;
import org.ldp4j.rdf.util.TripleSet;

final class JARBContextImpl
extends JARBContext {
    private final MemoizedDeployments deployments;
    private final TransactionalTypeRegistry registry;

    JARBContextImpl(NamingPolicy policy) {
        this.deployments = new MemoizedDeployments(policy);
        this.registry = new TransactionalTypeRegistry();
    }

    private <T> TypeProcessor<T> getTypeProcessor(Class<? extends T> clazz) {
        return new TypeProcessorImpl<T>(clazz, this.registry);
    }

    @Override
    public <T> Resource<?> getIdentity(T object) {
        return this.deployments.getIdentity(object);
    }

    @Override
    public <T> TripleSet deflate(T object) {
        Objects.requireNonNull(object, "Object cannot be null");
        TemporalDeploymentPolicy temporalPolicy = this.deployments.newTemporalDeploymentPolicy();
        TripleSet result = this.getTypeProcessor(object.getClass()).deflate(object, temporalPolicy);
        temporalPolicy.makePermanent();
        return result;
    }

    @Override
    public <T> T inflate(Resource<?> identity, TripleSet triples, Class<? extends T> clazz) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        Objects.requireNonNull(triples, "Triples cannot be null");
        Objects.requireNonNull(clazz, "Class cannot be null");
        return this.getTypeProcessor(clazz).inflate(identity, triples);
    }

    private static class TemporalDeploymentPolicy
    implements NamingPolicy {
        private final Map<Object, Resource<?>> newDeployments;
        private final Memoizer memoizer;
        private final NamingPolicy policy;

        private TemporalDeploymentPolicy(Memoizer memoizer, NamingPolicy policy) {
            this.memoizer = memoizer;
            this.policy = policy;
            this.newDeployments = new HashMap();
        }

        @Override
        public <T> Resource<?> createIdentity(T object) {
            Resource<?> identity = this.memoizer.getMemoizedIdentity(object);
            if (identity == null) {
                identity = this.policy.createIdentity(object);
                this.newDeployments.put(object, identity);
            }
            return identity;
        }

        private void makePermanent() {
            this.memoizer.memoize(this.newDeployments);
        }

        @Override
        public <T> Resource<?> enumeratedIdentity(T object) {
            Resource<?> identity = this.memoizer.getMemoizedIdentity(object);
            if (identity == null) {
                identity = this.policy.enumeratedIdentity(object);
                this.newDeployments.put(object, identity);
            }
            return identity;
        }

        @Override
        public <T> T resolveEnumerated(Resource<?> identity, Class<? extends T> clazz) {
            throw new UnsupportedOperationException("Method not implemented yet");
        }
    }

    private static class MemoizedDeployments {
        private final Map<Object, Resource<?>> deployments;
        private final NamingPolicy policy;
        private final Memoizer memoizer;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        private MemoizedDeployments(NamingPolicy policy) {
            this.policy = policy;
            this.deployments = new HashMap();
            this.memoizer = new Memoizer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoize(Map<Object, Resource<?>> newDeployments) {
                    MemoizedDeployments.this.lock.writeLock().lock();
                    try {
                        MemoizedDeployments.this.deployments.putAll(newDeployments);
                    }
                    finally {
                        MemoizedDeployments.this.lock.writeLock().unlock();
                    }
                }

                @Override
                public <T> Resource<?> getMemoizedIdentity(T object) {
                    return MemoizedDeployments.this.getIdentity(object);
                }
            };
        }

        private TemporalDeploymentPolicy newTemporalDeploymentPolicy() {
            return new TemporalDeploymentPolicy(this.memoizer, this.policy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> Resource<?> getIdentity(T object) {
            this.lock.readLock().lock();
            try {
                Resource<?> resource = this.deployments.get(object);
                return resource;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    private static interface Memoizer {
        public void memoize(Map<Object, Resource<?>> var1);

        public <T> Resource<?> getMemoizedIdentity(T var1);
    }
}

