/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ldp4j.rdf.bean.Category;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.Vocabulary;
import org.ldp4j.rdf.bean.annotations.VocabularyProvider;
import org.ldp4j.rdf.bean.impl.EnumerationHelper;
import org.ldp4j.rdf.bean.impl.PropertyScanner;
import org.ldp4j.rdf.bean.impl.StringUtils;
import org.ldp4j.rdf.bean.impl.TypeDefinition;
import org.ldp4j.rdf.bean.impl.TypeManager;
import org.ldp4j.rdf.bean.impl.VocabularyDefinition;
import org.ldp4j.rdf.bean.spi.IVocabularyProvider;

final class DefinitionLoader {
    private DefinitionLoader() {
    }

    static Vocabulary loadVocabulary(Package target, TypeManager manager) {
        Objects.requireNonNull(target, "Target package cannot be null");
        Objects.requireNonNull(manager, "Type manager cannot be null");
        return new VocabularyLoader(manager).load(target);
    }

    static Type loadType(Class<?> clazz, TypeManager manager) {
        Objects.requireNonNull(clazz, "Class cannot be null");
        Objects.requireNonNull(manager, "Type manager cannot be null");
        return new TypeLoader(manager).load(clazz);
    }

    private static final class TypeLoader {
        private final TypeManager manager;

        private TypeLoader(TypeManager manager) {
            this.manager = manager;
        }

        Type load(Class<?> clazz) {
            Type result = this.manager.getRegistry().lookup(clazz);
            if (result == null) {
                this.loadTypeDefinition(clazz, this.manager);
                result = this.manager.getRegistry().lookup(clazz);
            }
            return result;
        }

        private String getTypeName(String name, Class<?> clazz) {
            return StringUtils.nonEmptyOrDefault(name, clazz.getSimpleName());
        }

        private String getTypeNamespace(String namespace, Class<?> clazz) {
            String result = StringUtils.nonEmptyOrNull(namespace);
            if (result == null) {
                Package targetPackage = clazz.getPackage();
                if (targetPackage == null) {
                    throw new InvalidDefinitionException("Invalid type declaration: orphan types are not allowed");
                }
                result = VocabularyLoader.getVocabularyNamespace(targetPackage);
            }
            return result;
        }

        private void loadTypeDefinition(Class<?> clazz, TypeManager manager) {
            org.ldp4j.rdf.bean.annotations.Type type = clazz.getAnnotation(org.ldp4j.rdf.bean.annotations.Type.class);
            if (type != null) {
                String name = this.getTypeName(type.name(), clazz);
                String namespace = this.getTypeNamespace(type.namespace(), clazz);
                Category category = type.category();
                TypeDefinition definition = new TypeDefinition(name, namespace, category, clazz);
                manager.getRegistry().register(clazz, definition);
                PropertyScanner scanner = new PropertyScanner(clazz, namespace);
                TypeDefinition.initiliazeProperties(definition, scanner.getProperties(manager));
                if (Category.ENUMERATION.equals((Object)category)) {
                    TypeDefinition.setHelper(definition, EnumerationHelper.newInstance(clazz));
                }
            }
        }
    }

    private static final class VocabularyLoader {
        private final TypeManager manager;

        private VocabularyLoader(TypeManager manager) {
            this.manager = manager;
        }

        Vocabulary load(Package target) {
            Vocabulary result = this.loadFromProvider(target);
            if (result == null) {
                result = this.loadFromDefinition(target);
            }
            return result;
        }

        private Vocabulary loadFromDefinition(Package target) {
            org.ldp4j.rdf.bean.annotations.Vocabulary vocabulary = target.getAnnotation(org.ldp4j.rdf.bean.annotations.Vocabulary.class);
            VocabularyDefinition result = null;
            if (vocabulary != null) {
                String namespace = VocabularyLoader.getVocabularyNamespace(target);
                String prefix = StringUtils.nonEmptyOrNull(vocabulary.prefix());
                List<Type> types = this.getVocabularyTypes(vocabulary.types());
                result = new VocabularyDefinition(namespace, prefix, types);
            }
            return result;
        }

        private List<Type> getVocabularyTypes(Class<?>[] types) {
            ArrayList<Type> result = new ArrayList<Type>();
            for (Class<?> clazz : types) {
                List<Type> definitions = this.manager.getTypes(clazz);
                if (definitions.isEmpty()) {
                    throw new InvalidDefinitionException("Invalid vocabulary definition: class '" + clazz.getCanonicalName() + "' does not denote a type");
                }
                result.add(definitions.get(0));
            }
            return result;
        }

        private Vocabulary loadFromProvider(Package target) {
            VocabularyProvider provider = target.getAnnotation(VocabularyProvider.class);
            Vocabulary result = null;
            if (provider != null) {
                Class<? extends IVocabularyProvider> clazz = provider.provider();
                try {
                    result = clazz.newInstance().getInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            return result;
        }

        private static String getVocabularyNamespace(Package vocabulary) {
            if (vocabulary == null) {
                return null;
            }
            org.ldp4j.rdf.bean.annotations.Vocabulary definition = vocabulary.getAnnotation(org.ldp4j.rdf.bean.annotations.Vocabulary.class);
            if (definition == null) {
                return VocabularyLoader.getPackageNamespace(vocabulary);
            }
            String result = StringUtils.nonEmptyOrNull(definition.namespace());
            if (result == null) {
                throw new InvalidDefinitionException("Invalid vocabulary declaration: namespace definition is required");
            }
            return result;
        }

        private static String getPackageNamespace(Package pack) {
            String[] segments = pack.getName().split("\\.");
            StringBuilder authority = new StringBuilder();
            if (segments.length == 1) {
                authority.append(segments[0]);
            } else {
                authority.append(segments[1]).append(".").append(segments[0]);
                for (int i = 2; i < segments.length; ++i) {
                    authority.append("/").append(segments[i]);
                }
            }
            return String.format("http://%s/", authority);
        }
    }
}

