/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ldp4j.rdf.bean.Cardinality;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.annotations.AtLeast;
import org.ldp4j.rdf.bean.annotations.AtMost;
import org.ldp4j.rdf.bean.annotations.CardinalityConstraint;
import org.ldp4j.rdf.bean.annotations.Optional;
import org.ldp4j.rdf.bean.annotations.Range;
import org.ldp4j.rdf.bean.annotations.Unbound;
import org.ldp4j.rdf.bean.impl.TypeSupport;

final class CardinalityDefinition
implements Cardinality {
    private final boolean repetitions;
    private final int min;
    private final int max;

    private CardinalityDefinition(int min, int max, boolean repetitions) {
        this.min = min;
        this.max = max;
        this.repetitions = repetitions;
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public boolean isOptional() {
        return this.min == 0;
    }

    @Override
    public boolean isUnbounded() {
        return this.max < 0;
    }

    @Override
    public boolean allowsRepetitions() {
        return this.repetitions;
    }

    static Cardinality fromConstraints(Type type, List<Annotation> constraints) {
        CardinalityConstraintValidator validator = new CardinalityConstraintValidator(constraints);
        if (!validator.isValid(type)) {
            throw new InvalidDefinitionException(validator.getReport());
        }
        return new CardinalityDefinition(validator.min(), validator.max(), validator.isRepeteable());
    }

    public String toString() {
        return "CardinalityDefinition [repetitions=" + this.repetitions + ", min=" + this.min + ", max=" + (this.max < 0 ? "UNBOUND" : Integer.toString(this.max)) + "]";
    }

    private static final class CardinalityConstraintValidator {
        private final Acumulator min = new Acumulator();
        private final Acumulator max = new Acumulator();
        private final Map<String, String> violations = new HashMap<String, String>();
        private final List<Annotation> constraints;
        private boolean optional;
        private boolean unbound;
        private boolean simple;
        private boolean repetitions;

        CardinalityConstraintValidator(List<Annotation> constraints) {
            this.constraints = constraints;
            for (Annotation genericConstraint : constraints) {
                this.validateGenericConstraint(genericConstraint);
            }
            if (this.isUnbound() && this.hasMax()) {
                this.addViolation("Cannot have max cardinality if unbound");
            }
            if (this.isOptional() && this.hasMin()) {
                this.addViolation("Cannot have min cardinality if optional");
            }
        }

        private void validateGenericConstraint(Annotation genericConstraint) {
            if (genericConstraint instanceof AtLeast) {
                this.validateAtLeast((AtLeast)genericConstraint);
            } else if (genericConstraint instanceof AtMost) {
                this.validateAtMost((AtMost)genericConstraint);
            } else if (genericConstraint instanceof Range) {
                this.validatRange((Range)genericConstraint);
            } else if (genericConstraint instanceof Optional) {
                this.optional = true;
            } else if (genericConstraint instanceof Unbound) {
                this.unbound = true;
            } else {
                this.addViolation("assertion", "Unsupported cardinality constraint '" + genericConstraint.getClass().getCanonicalName() + "'");
            }
        }

        private void addViolation(String violation) {
            this.addViolation("combination", violation);
        }

        private void addViolation(String source, String violation) {
            this.violations.put(source, violation);
        }

        private void addViolation(Annotation source, String violation) {
            this.addViolation(source.annotationType().getSimpleName(), violation);
        }

        private void setMin(int min) {
            this.min.setValue(min);
        }

        private void setMax(int max) {
            this.max.setValue(max);
        }

        private void validatRange(Range constraint) {
            if (constraint.min() < 0) {
                this.addViolation(constraint, "Min cardinality cannot be lower than 0");
            }
            if (constraint.max() < 1) {
                this.addViolation(constraint, "Max cardinality cannot be lower than 1");
            }
            if (constraint.min() > constraint.max()) {
                this.addViolation(constraint, "Max cardinality cannot be lower than min cardinality");
            }
            this.setMin(constraint.min());
            this.setMax(constraint.max());
        }

        private void validateAtMost(AtMost constraint) {
            if (constraint.max() < 2) {
                this.addViolation(constraint, "Max cardinality cannot be lower than 2");
            }
            this.setMin(constraint.max());
        }

        private void validateAtLeast(AtLeast constraint) {
            if (constraint.min() < 1) {
                this.addViolation(constraint, "Min cardinality cannot be lower than 1");
            }
            this.setMin(constraint.min());
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isUnbound() {
            return this.unbound;
        }

        public boolean hasMin() {
            return this.min.isDefined();
        }

        public boolean hasMax() {
            return this.max.isDefined();
        }

        public int min() {
            if (this.hasMin()) {
                return this.min.getValue();
            }
            if (this.isOptional()) {
                return 0;
            }
            return 1;
        }

        public int max() {
            if (this.hasMax()) {
                return this.max.getValue();
            }
            if (this.isSimple()) {
                return 1;
            }
            return -1;
        }

        public boolean isValid(Type type) {
            boolean result = this.violations.isEmpty();
            if (result) {
                Class clazz = null;
                if (type instanceof Class) {
                    clazz = (Class)type;
                } else if (type instanceof ParameterizedType) {
                    clazz = (Class)((ParameterizedType)type).getRawType();
                } else if (type instanceof TypeVariable) {
                    clazz = (Class)((TypeVariable)type).getBounds()[0];
                } else {
                    this.addViolation("assertion", "Unsupported range type '" + type + "'");
                }
                if (clazz != null) {
                    this.simple = !TypeSupport.isAggregation(clazz);
                    this.repetitions = this.simple ? false : TypeSupport.isRepeatable(clazz);
                    for (Annotation constraint : this.constraints) {
                        CardinalityConstraint cc = constraint.annotationType().getAnnotation(CardinalityConstraint.class);
                        this.verifyApplicability(type, clazz, constraint, cc.appliesTo());
                    }
                }
                result = this.violations.isEmpty();
            }
            return result;
        }

        private void verifyApplicability(Type type, Class<?> clazz, Annotation constraint, Class<?>[] appliesTo) {
            for (int i = 0; i < appliesTo.length; ++i) {
                if (appliesTo[i].isAssignableFrom(clazz)) continue;
                this.addViolation(constraint, "Constraint cannot be applied to type '" + type + "'");
                break;
            }
        }

        public boolean isSimple() {
            return this.simple;
        }

        public boolean isRepeteable() {
            return this.repetitions;
        }

        public String getReport() {
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            out.printf("Cardinality definition violations found (%d):", this.violations.size());
            for (Map.Entry<String, String> violation : this.violations.entrySet()) {
                out.printf("%n\t- %s (%s)", violation.getValue(), violation.getKey());
            }
            return result.toString();
        }

        private static final class Acumulator {
            private Integer value;
            private boolean redefined;
            private boolean overriden;

            private Acumulator() {
            }

            public void setValue(int value) {
                if (this.value == null) {
                    this.value = value;
                } else {
                    this.redefined = true;
                    if (!this.overriden) {
                        this.overriden = this.value != value;
                    }
                }
            }

            public int getValue() {
                return this.value;
            }

            public boolean isDefined() {
                return !this.redefined && this.value != null;
            }

            public boolean isOverriden() {
                return this.overriden;
            }
        }
    }
}

