/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import org.ldp4j.rdf.bean.meta.MetaAnnotation;
import org.ldp4j.rdf.bean.meta.annotations.Meta;

class MetaAnnotationHelper {
    MetaAnnotationHelper() {
    }

    static boolean isMetaAnnotation(Class<? extends Annotation> clazz) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!MetaAnnotationHelper.isMetaAnnotationAnnotation(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMetaAnnotationAnnotation(Class<? extends Annotation> type) {
        if (MetaAnnotation.class.equals(type)) {
            return true;
        }
        for (Annotation annotation : type.getAnnotations()) {
            if (!Meta.class.equals(annotation.annotationType())) continue;
            return true;
        }
        return MetaAnnotationHelper.isSelfAnnotatedMetaAnnotation(type);
    }

    private static boolean isSelfAnnotatedMetaAnnotation(Class<? extends Annotation> type) {
        if (MetaAnnotationHelper.isSelfAnnotated(type, "MetaAnnotation")) {
            return true;
        }
        for (Annotation annotation : type.getAnnotations()) {
            if (!MetaAnnotationHelper.isSelfAnnotated(annotation.annotationType(), "Meta")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelfAnnotated(Class<? extends Annotation> type, String name) {
        return type.isAnnotationPresent(type) && type.getSimpleName().equals(name) && MetaAnnotationHelper.validTarget(type);
    }

    private static boolean validTarget(Class<? extends Annotation> type) {
        Target target = type.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        ElementType[] targets = target.value();
        return targets.length == 1 && targets[0] == ElementType.ANNOTATION_TYPE;
    }
}

