/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ldp4j.rdf.bean.meta.Parameterized;

final class ParameterMap
implements Parameterized {
    private final List<TypeVariable<?>> parameters;
    private final List<String> parameterNames;
    private final Map<String, Integer> parameterIndex;
    private final Map<TypeVariable<?>, Type> resolutions;

    private ParameterMap(List<TypeVariable<?>> parameters, Map<TypeVariable<?>, Type> resolutions) {
        this.parameters = parameters;
        this.parameterNames = new ArrayList<String>();
        this.parameterIndex = new HashMap<String, Integer>();
        this.resolutions = resolutions;
        for (int i = 0; i < parameters.size(); ++i) {
            TypeVariable<?> parameter = this.parameters.get(i);
            this.parameterNames.add(parameter.getName());
            this.parameterIndex.put(parameter.getName(), i);
        }
    }

    public ParameterMap(TypeVariable<?>[] parameters) {
        this(Arrays.asList(parameters), ParameterMap.emptyResolution(parameters));
    }

    public ParameterMap(TypeVariable<?>[] parameters, Type[] actualTypeArguments) {
        this(Arrays.asList(parameters), ParameterMap.simpleResolution(parameters, actualTypeArguments));
    }

    public ParameterMap(TypeVariable<?>[] parameters, Type[] actualTypeArguments, Parameterized ctx) {
        this(Arrays.asList(parameters), ParameterMap.annealedResolution(parameters, actualTypeArguments, ctx));
    }

    private static Map<TypeVariable<?>, Type> emptyResolution(TypeVariable<?>[] parameters) {
        HashMap result = new HashMap();
        for (int i = 0; i < parameters.length; ++i) {
            result.put(parameters[i], parameters[i]);
        }
        return result;
    }

    private static Map<TypeVariable<?>, Type> simpleResolution(TypeVariable<?>[] parameters, Type[] actualTypeArguments) {
        HashMap result = new HashMap();
        for (int i = 0; i < parameters.length; ++i) {
            result.put(parameters[i], actualTypeArguments[i]);
        }
        return result;
    }

    private static Map<TypeVariable<?>, Type> annealedResolution(TypeVariable<?>[] parameters, Type[] actualTypeArguments, Parameterized resolution) {
        HashMap result = new HashMap();
        for (int i = 0; i < parameters.length; ++i) {
            TypeVariable annealedParameter;
            Type annealedArgument;
            TypeVariable<?> parameter = parameters[i];
            Type argument = actualTypeArguments[i];
            if (argument instanceof TypeVariable && (annealedArgument = resolution.getParameterArgument((annealedParameter = (TypeVariable)argument).getName())) != null) {
                argument = annealedArgument;
            }
            result.put(parameter, argument);
        }
        return result;
    }

    @Override
    public List<String> parameterNames() {
        return Collections.unmodifiableList(this.parameterNames);
    }

    @Override
    public TypeVariable<?> getParameter(String name) {
        if (!this.parameterNames.contains(name)) {
            throw new IllegalArgumentException("Unknown type parameter '" + name + "'");
        }
        return this.parameters.get(this.parameterIndex.get(name));
    }

    @Override
    public Type getParameterArgument(String name) {
        return this.resolutions.get(this.getParameter(name));
    }

    @Override
    public Class<?> getActualParameterArgument(String name) {
        return this.resolveType(this.resolutions.get(this.getParameter(name)));
    }

    private Class<?> resolveType(Type argument) {
        TypeVariable var;
        Type[] bounds;
        Class result = null;
        if (argument instanceof TypeVariable && (bounds = (var = (TypeVariable)argument).getBounds()).length > 0 && bounds[0] instanceof Class) {
            result = (Class)bounds[0];
        }
        return result;
    }
}

