/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ldp4j.rdf.bean.meta.Annotated;
import org.ldp4j.rdf.bean.meta.AnnotatedClass;
import org.ldp4j.rdf.bean.meta.AnnotatedField;
import org.ldp4j.rdf.bean.meta.AnnotatedMember;
import org.ldp4j.rdf.bean.meta.AnnotatedMethod;
import org.ldp4j.rdf.bean.meta.MetaAnnotatedObject;
import org.ldp4j.rdf.bean.meta.MetaProperty;
import org.ldp4j.rdf.bean.util.BeanUtils;

public final class MetaType<T>
extends MetaAnnotatedObject<AnnotatedClass<T>> {
    private final Map<String, MetaProperty<?>> metaproperties;
    private final AnnotatedClass<T> clazz;

    private MetaType(AnnotatedClass<T> clazz, List<MetaProperty<?>> properties) {
        super(clazz, MetaType.getClassHierarchy(clazz));
        this.clazz = clazz;
        this.metaproperties = new HashMap();
        for (MetaProperty<?> property : properties) {
            if (!this.metaproperties.containsKey(property.getName())) {
                this.metaproperties.put(property.getName(), property);
                continue;
            }
            String newPropertyName = property.getName() + "#" + property.getOwnerType();
            this.metaproperties.put(newPropertyName, MetaProperty.rename(newPropertyName, property));
        }
    }

    private static List<? extends Annotated<?>> getClassHierarchy(AnnotatedClass<?> clazz) {
        ArrayList result = new ArrayList();
        for (AnnotatedClass<?> root = clazz; root != null; root = root.getSuperclass()) {
            result.add(root);
        }
        return result;
    }

    @Override
    public AnnotatedClass<T> get() {
        return this.clazz;
    }

    public boolean hasProperty(String propertyName) {
        return this.metaproperties.containsKey(propertyName);
    }

    public Set<String> properties() {
        return new TreeSet<String>(this.metaproperties.keySet());
    }

    public MetaProperty<?> getProperty(String propertyName) {
        return this.metaproperties.get(propertyName);
    }

    public static <T> MetaType<T> forClass(Class<T> clazz) {
        PropertyScanner scanner = new PropertyScanner();
        AnnotatedClass<T> metaClass = AnnotatedClass.forClass(clazz);
        return new MetaType<T>(metaClass, scanner.scan(metaClass));
    }

    public static <T> MetaType<T> forObject(T object) {
        return MetaType.forClass(object.getClass());
    }

    public static class PropertyScanner {
        public List<MetaProperty<?>> scan(AnnotatedClass<?> context) {
            ArrayList result = new ArrayList();
            for (Map.Entry<String, List<AnnotatedMethod>> entry : this.getClassifiedGetters(context).entrySet()) {
                result.add(MetaProperty.forMethods(context, entry.getValue()));
            }
            for (AnnotatedField field : this.getCandidateFields(context)) {
                result.add(MetaProperty.forField(context, field));
            }
            return result;
        }

        private Map<String, List<AnnotatedMethod>> getClassifiedGetters(AnnotatedClass<?> metaClass) {
            HashMap<String, List<AnnotatedMethod>> classification = new HashMap<String, List<AnnotatedMethod>>();
            for (AnnotatedMethod method : this.getCandidateGetters(metaClass)) {
                ArrayList<AnnotatedMethod> methods = (ArrayList<AnnotatedMethod>)classification.get(method.getName());
                if (methods == null) {
                    methods = new ArrayList<AnnotatedMethod>();
                    classification.put(method.getName(), methods);
                }
                methods.add(method);
            }
            return classification;
        }

        private Collection<AnnotatedMethod> getCandidateGetters(AnnotatedClass<?> metaClass) {
            FilteringMethodCollector collector = new FilteringMethodCollector();
            collector.setFilter(new GetterFilter());
            return collector.collect(metaClass);
        }

        private Collection<AnnotatedField> getCandidateFields(AnnotatedClass<?> metaClass) {
            FilteringFieldCollector collector = new FilteringFieldCollector();
            collector.setFilter(new FilteringMemberCollector.Filter<Field, AnnotatedField>(){

                @Override
                public boolean isValid(AnnotatedField member) {
                    return true;
                }
            });
            return collector.collect(metaClass);
        }

        private static final class GetterFilter
        implements FilteringMemberCollector.Filter<Method, AnnotatedMethod> {
            private GetterFilter() {
            }

            @Override
            public boolean isValid(AnnotatedMethod member) {
                return BeanUtils.isGetter((Method)((Method)member.get()));
            }
        }

        public static class FilteringMethodCollector
        extends FilteringMemberCollector<Method, AnnotatedMethod> {
            @Override
            protected Collection<AnnotatedMethod> getRawMembers(AnnotatedClass<?> root) {
                return root.getDeclaredMethods();
            }
        }

        public static class FilteringFieldCollector
        extends FilteringMemberCollector<Field, AnnotatedField> {
            @Override
            protected Collection<AnnotatedField> getRawMembers(AnnotatedClass<?> root) {
                return root.getDeclaredField();
            }
        }

        protected static abstract class FilteringMemberCollector<S extends Member, T extends AnnotatedMember<S>>
        implements MemberCollector<S, T> {
            private Filter<S, T> filter;

            protected FilteringMemberCollector() {
            }

            public final void setFilter(Filter<S, T> filter) {
                this.filter = filter;
            }

            public final Filter<S, T> getFilter() {
                if (this.filter == null) {
                    this.filter = new Filter<S, T>(){

                        @Override
                        public boolean isValid(T member) {
                            return false;
                        }
                    };
                }
                return this.filter;
            }

            @Override
            public final Collection<T> collect(AnnotatedClass<?> root) {
                ArrayList<AnnotatedMember> result = new ArrayList<AnnotatedMember>();
                Filter<S, AnnotatedMember> filterInUse = this.getFilter();
                for (AnnotatedClass<?> clazz = root; clazz != null; clazz = clazz.getSuperclass()) {
                    for (AnnotatedMember member : this.getRawMembers(clazz)) {
                        if (!filterInUse.isValid(member)) continue;
                        result.add(member);
                    }
                }
                return result;
            }

            protected abstract Collection<T> getRawMembers(AnnotatedClass<?> var1);

            public static interface Filter<S extends Member, T extends AnnotatedMember<S>> {
                public boolean isValid(T var1);
            }
        }

        private static interface MemberCollector<S extends Member, T extends AnnotatedMember<S>> {
            public Collection<T> collect(AnnotatedClass<?> var1);
        }
    }
}

