/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.ldp4j.rdf.bean.meta.AnnotatedBeanUtils;
import org.ldp4j.rdf.bean.meta.AnnotatedClass;
import org.ldp4j.rdf.bean.meta.AnnotatedField;
import org.ldp4j.rdf.bean.meta.AnnotatedMember;
import org.ldp4j.rdf.bean.meta.AnnotatedMethod;
import org.ldp4j.rdf.bean.meta.MetaAnnotatedObject;
import org.ldp4j.rdf.bean.util.TypeUtils;

public abstract class MetaProperty<T extends AnnotatedMember<?>>
extends MetaAnnotatedObject<T> {
    private MetaProperty(List<T> elements) {
        super(elements.get(0), elements);
    }

    private MetaProperty(MetaProperty<T> provider) {
        super(provider);
    }

    public abstract String getName();

    public abstract VariableScope getTypeVariableScope();

    public abstract boolean isTypeVariable();

    public abstract Class<?> getRawType();

    public abstract Type getGenericType();

    public abstract Class<?> getType();

    public abstract AnnotatedClass<?> getContextType();

    public abstract AnnotatedClass<?> getOwnerType();

    public abstract Object getValue(Object var1);

    public abstract boolean isWritable();

    public abstract void setValue(Object var1, Object var2);

    public String toString() {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("name=" + this.getName());
        segments.add("type=" + this.getType().getCanonicalName());
        if (this.isTypeVariable()) {
            TypeVariable typeVariable = (TypeVariable)this.getGenericType();
            segments.add("genericType=" + typeVariable.getName());
            segments.add("variableScope=" + (Object)((Object)this.getTypeVariableScope()) + " {" + TypeUtils.toString((Type)typeVariable) + "}");
        } else {
            segments.add("genericType=" + TypeUtils.toString((Type)this.getGenericType()));
        }
        segments.add("ownerType=" + this.getOwnerType());
        segments.add("contextType=" + this.getContextType());
        segments.add("writable=" + this.isWritable());
        StringBuilder out = new StringBuilder();
        out.append("MetaProperty [");
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            out.append((String)it.next());
            if (!it.hasNext()) continue;
            out.append(", ");
        }
        out.append("]");
        return out.toString();
    }

    static MetaProperty<AnnotatedField> forField(AnnotatedClass<?> context, AnnotatedField field) {
        return new FieldMetaProperty(context, field);
    }

    static MetaProperty<AnnotatedMethod> forMethods(AnnotatedClass<?> context, List<AnnotatedMethod> methods) {
        AnnotatedMethod actualGetter = methods.get(0);
        String name = AnnotatedBeanUtils.getPropertyName(actualGetter);
        Class<?> rawType = actualGetter.getRawReturnType();
        AnnotatedMethod actualSetter = AnnotatedBeanUtils.findSetter(context, name, rawType);
        return new MethodMetaProperty(context, methods, name, rawType, actualGetter, actualSetter);
    }

    static <T extends AnnotatedMember<?>> MetaProperty<T> rename(String newName, MetaProperty<T> property) {
        return new RenamedMetaProperty(property, newName);
    }

    private static final class RenamedMetaProperty<T extends AnnotatedMember<?>>
    extends MetaProperty<T> {
        private final MetaProperty<T> delegate;
        private final String newName;

        private RenamedMetaProperty(MetaProperty<T> delegate, String newName) {
            super(delegate);
            this.delegate = delegate;
            this.newName = newName;
        }

        @Override
        public String getName() {
            return this.newName;
        }

        @Override
        public VariableScope getTypeVariableScope() {
            return this.getDelegate().getTypeVariableScope();
        }

        @Override
        public boolean isTypeVariable() {
            return this.getDelegate().isTypeVariable();
        }

        @Override
        public Class<?> getRawType() {
            return this.getDelegate().getRawType();
        }

        @Override
        public Type getGenericType() {
            return this.getDelegate().getGenericType();
        }

        @Override
        public Class<?> getType() {
            return this.getDelegate().getType();
        }

        @Override
        public AnnotatedClass<?> getContextType() {
            return this.getDelegate().getContextType();
        }

        @Override
        public AnnotatedClass<?> getOwnerType() {
            return this.getDelegate().getOwnerType();
        }

        @Override
        public Object getValue(Object object) {
            return this.getDelegate().getValue(object);
        }

        @Override
        public boolean isWritable() {
            return this.getDelegate().isWritable();
        }

        @Override
        public void setValue(Object object, Object value) {
            this.getDelegate().setValue(object, value);
        }

        @Override
        public T get() {
            return (T)((AnnotatedMember)this.delegate.get());
        }

        public MetaProperty<T> getDelegate() {
            return this.delegate;
        }
    }

    private static final class MethodMetaProperty
    extends AbstractMetaProperty<AnnotatedMethod> {
        private final List<AnnotatedMethod> methods;
        private final AnnotatedMethod actualGetter;
        private final AnnotatedMethod actualSetter;

        private MethodMetaProperty(AnnotatedClass<?> context, List<AnnotatedMethod> methods, String name, Class<?> rawType, AnnotatedMethod actualGetter, AnnotatedMethod actualSetter) {
            super(context, name, actualGetter.getReturnType(), actualGetter.getGenericReturnType(), rawType, methods);
            this.methods = methods;
            this.actualGetter = actualGetter;
            this.actualSetter = actualSetter;
        }

        @Override
        public Object getValue(Object object) {
            try {
                return this.actualGetter.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean isWritable() {
            return this.actualSetter != null;
        }

        @Override
        protected void doSetValue(Object object, Object value) {
            try {
                this.actualSetter.invoke(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public List<AnnotatedMethod> getMethods() {
            return this.methods;
        }

        @Override
        public AnnotatedClass<?> getOwnerType() {
            return this.actualGetter.getDeclaringClass();
        }

        @Override
        public AnnotatedMethod get() {
            return this.actualGetter;
        }
    }

    private static final class FieldMetaProperty
    extends AbstractMetaProperty<AnnotatedField> {
        private final AnnotatedField field;

        private FieldMetaProperty(AnnotatedClass<?> context, AnnotatedField field) {
            super(context, field.getName(), field.getType(), field.getGenericType(), field.getRawType(), new AnnotatedField[]{field});
            this.field = field;
        }

        @Override
        public Object getValue(Object object) {
            try {
                return this.field.getValue(object);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean isWritable() {
            return this.field.isAccessible();
        }

        @Override
        protected void doSetValue(Object object, Object value) {
            try {
                this.field.setValue(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public AnnotatedClass<?> getOwnerType() {
            return this.field.getDeclaringClass();
        }

        @Override
        public AnnotatedField get() {
            return this.field;
        }
    }

    private static abstract class AbstractMetaProperty<T extends AnnotatedMember<?>>
    extends MetaProperty<T> {
        private final String name;
        private final Class<?> type;
        private final Type genericType;
        private final Class<?> rawType;
        private final VariableScope scope;
        private final AnnotatedClass<?> context;

        @SafeVarargs
        private AbstractMetaProperty(AnnotatedClass<?> context, String name, Class<?> type, Type genericType, Class<?> rawType, T ... elements) {
            this(context, name, type, genericType, rawType, Arrays.asList(elements));
        }

        private AbstractMetaProperty(AnnotatedClass<?> context, String name, Class<?> type, Type genericType, Class<?> rawType, List<T> elements) {
            super(elements);
            this.context = context;
            this.name = name;
            this.type = type;
            this.genericType = genericType;
            this.rawType = rawType;
            this.scope = VariableScope.fromType(genericType);
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final VariableScope getTypeVariableScope() {
            return this.scope;
        }

        @Override
        public final boolean isTypeVariable() {
            return this.genericType instanceof TypeVariable;
        }

        @Override
        public final Class<?> getRawType() {
            return this.rawType;
        }

        @Override
        public final Type getGenericType() {
            return this.genericType;
        }

        @Override
        public final Class<?> getType() {
            return this.type;
        }

        @Override
        public final AnnotatedClass<?> getContextType() {
            return this.context;
        }

        @Override
        public void setValue(Object object, Object value) {
            if (!this.isWritable()) {
                throw new IllegalStateException("Property is not writable");
            }
            if (!this.getRawType().isInstance(value)) {
                throw new IllegalArgumentException("Value is not of the expected type (" + value.getClass().getCanonicalName() + " is not instance of " + this.getRawType().getCanonicalName() + ")");
            }
            this.doSetValue(object, value);
        }

        protected abstract void doSetValue(Object var1, Object var2);
    }

    public static enum VariableScope {
        TYPE,
        METHOD;


        static VariableScope fromType(Type genericType) {
            VariableScope result = null;
            if (genericType instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)genericType;
                result = tv.getGenericDeclaration() instanceof Type ? TYPE : METHOD;
            }
            return result;
        }
    }
}

