/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ldp4j.rdf.bean.meta.Annotated;
import org.ldp4j.rdf.bean.meta.MetaAnnotated;
import org.ldp4j.rdf.bean.meta.MetaAnnotation;

final class MetaAnnotationSupport<T>
implements MetaAnnotated<T> {
    private final Map<Class<? extends Annotation>, MetaAnnotation<? extends Annotation>> metaAnnotations = new HashMap<Class<? extends Annotation>, MetaAnnotation<? extends Annotation>>();
    private final Annotated<?> annotated;
    private final T metaAnnotated;

    private MetaAnnotationSupport(T metaAnnotated, Annotated<?> annotated) {
        this.metaAnnotated = metaAnnotated;
        this.annotated = annotated;
    }

    @Override
    public T get() {
        return this.metaAnnotated;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.metaAnnotations.containsKey(annotationClass);
    }

    public <S extends Annotation> S getAnnotation(Class<S> annotationClass) {
        MetaAnnotation<? extends Annotation> annotation = this.metaAnnotations.get(annotationClass);
        return (S)(annotation == null ? null : annotation.get());
    }

    @Override
    public Annotation[] getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (MetaAnnotation<? extends Annotation> metaAnnotation : this.metaAnnotations.values()) {
            for (MetaAnnotation.AnnotationDeclaration<? extends Annotation> declaration : metaAnnotation.getDeclarations()) {
                annotations.add(declaration.get());
            }
        }
        Annotation[] result = new Annotation[this.metaAnnotations.size()];
        return annotations.toArray(result);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotated.getDeclaredAnnotations();
    }

    @Override
    public boolean isMetaAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.metaAnnotations.containsKey(annotationClass);
    }

    @Override
    public <S extends Annotation> MetaAnnotation<S> getMetaAnnotation(Class<S> annotationClass) {
        return this.metaAnnotations.get(annotationClass);
    }

    @Override
    public Collection<MetaAnnotation<?>> getMetaAnnotations() {
        return this.metaAnnotations.values();
    }

    private static <T, S extends Annotation> void addMetaAnnotation(S annotation, Annotated<?> scope, MetaAnnotationSupport<T> map) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        MetaAnnotation<Annotation> metaAnnotation = map.metaAnnotations.get(annotationType);
        if (metaAnnotation == null) {
            metaAnnotation = new MetaAnnotation();
            map.metaAnnotations.put(annotationType, metaAnnotation);
        }
        metaAnnotation.addDeclaration(annotation, scope);
    }

    static <T> MetaAnnotationSupport<T> forAnnotatedObjects(T object, List<? extends Annotated<?>> elements) {
        MetaAnnotationSupport<T> result = new MetaAnnotationSupport<T>(object, elements.get(0));
        for (Annotated<?> element : elements) {
            for (Annotation annotation : element.getDeclaredAnnotations()) {
                MetaAnnotationSupport.addMetaAnnotation(annotation, element, result);
            }
        }
        return result;
    }
}

