/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ldp4j.rdf.bean.meta.Annotated;

public final class MetaAnnotation<T extends Annotation> {
    private final List<AnnotationDeclaration<T>> declarations = new ArrayList<AnnotationDeclaration<T>>();
    private static final String NL = System.getProperty("line.separator");

    public T get() {
        return this.declarations.get(0).get();
    }

    public Annotated<?> getScope() {
        return this.declarations.get(0).getScope();
    }

    public boolean isOverriden() {
        return this.declarations.size() > 1;
    }

    public List<AnnotationDeclaration<T>> getDeclarations() {
        return Collections.unmodifiableList(new ArrayList<AnnotationDeclaration<T>>(this.declarations));
    }

    void addDeclaration(T annotation, Annotated<?> scope) {
        this.declarations.add(new AnnotationDeclaration((Annotation)annotation, scope, null));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetaAnnotation<").append(this.get().annotationType().getCanonicalName()).append("> {");
        int i = 0;
        Iterator<AnnotationDeclaration<T>> it = this.declarations.iterator();
        while (it.hasNext()) {
            builder.append(NL).append("\t[").append(i).append("] ").append(it.next());
            ++i;
        }
        builder.append(NL).append("}");
        return builder.toString();
    }

    static class 1 {
    }

    public static class AnnotationDeclaration<T extends Annotation> {
        private final T annotation;
        private final Annotated<?> scope;

        private AnnotationDeclaration(T annotation, Annotated<?> scope) {
            this.annotation = annotation;
            this.scope = scope;
        }

        public T get() {
            return this.annotation;
        }

        public Annotated<?> getScope() {
            return this.scope;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AnnotationDeclaration [");
            builder.append("annotation=").append(this.annotation).append(", ");
            builder.append("scope=").append(this.scope);
            builder.append("]");
            return builder.toString();
        }

        /* synthetic */ AnnotationDeclaration(Annotation x0, Annotated x1, 1 x2) {
            this(x0, x1);
        }
    }
}

