/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.ldp4j.rdf.bean.meta.MetaAnnotation;
import org.ldp4j.rdf.bean.meta.MetaProperty;
import org.ldp4j.rdf.bean.meta.MetaType;
import org.ldp4j.rdf.bean.meta.TestHarness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplementationDriver.class);

    @Test
    public void testAssumption$newScanner$non_generic() {
        Class[] classes = new Class[]{TestHarness.Root.class, TestHarness.GreaterGrandParent.class, TestHarness.GrandParent.class, TestHarness.Parent.class, TestHarness.Example.class};
        this.processClasses(classes);
    }

    private void processClasses(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            MetaType<?> metaClass = MetaType.forClass(clazz);
            LOGGER.trace("+ {}: ", (Object)clazz.getCanonicalName());
            for (String property : metaClass.properties()) {
                MetaProperty<?> metaProperty = metaClass.getProperty(property);
                LOGGER.trace("\t- {}", metaProperty);
            }
        }
    }

    @Test
    public void testAssumption$newScanner$generic() {
        Class[] classes = new Class[]{TestHarness.GenericRoot.class, TestHarness.GenericGreaterGrandParent.class, TestHarness.GenericGrandParent.class, TestHarness.GenericParent.class, TestHarness.GenericExample.class};
        this.processClasses(classes);
    }

    @Test
    public void testMetaClass$metaAnnotations() {
        TestHarness.GrandParent gp = new TestHarness.GrandParent();
        MetaType<TestHarness.GrandParent> metaClass = MetaType.forObject(gp);
        MetaAnnotation<TestHarness.CustomAnnotation> metaAnnotation = metaClass.getMetaAnnotation(TestHarness.CustomAnnotation.class);
        MatcherAssert.assertThat(metaAnnotation, (Matcher)Matchers.notNullValue());
        List<MetaAnnotation.AnnotationDeclaration<TestHarness.CustomAnnotation>> declarations = metaAnnotation.getDeclarations();
        MatcherAssert.assertThat(declarations, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)metaAnnotation.get(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(metaAnnotation.getScope(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)declarations.size(), (Matcher)Matchers.equalTo((Object)3));
        MetaAnnotation.AnnotationDeclaration[] array = declarations.toArray(new MetaAnnotation.AnnotationDeclaration[0]);
        MatcherAssert.assertThat((Object)metaAnnotation.get(), (Matcher)Matchers.sameInstance(array[0].get()));
        MatcherAssert.assertThat(metaAnnotation.getScope(), (Matcher)Matchers.sameInstance(array[0].getScope()));
        MatcherAssert.assertThat((Object)((TestHarness.CustomAnnotation)array[0].get()).value(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((TestHarness.CustomAnnotation)array[1].get()).value(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)((TestHarness.CustomAnnotation)array[2].get()).value(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void testMetaProperty$metaAnnotations() {
        TestHarness.GrandParent gp = new TestHarness.GrandParent();
        MetaType<TestHarness.GrandParent> metaClass = MetaType.forObject(gp);
        MetaProperty<?> metaProperty = metaClass.getProperty("parent");
        MetaAnnotation<TestHarness.CustomAnnotation> metaAnnotation = metaProperty.getMetaAnnotation(TestHarness.CustomAnnotation.class);
        MatcherAssert.assertThat(metaAnnotation, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)metaAnnotation.get(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(metaAnnotation.getScope(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)metaAnnotation.isOverriden(), (Matcher)Matchers.equalTo((Object)true));
        List<MetaAnnotation.AnnotationDeclaration<TestHarness.CustomAnnotation>> declarations = metaAnnotation.getDeclarations();
        MatcherAssert.assertThat(declarations, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)declarations.size(), (Matcher)Matchers.equalTo((Object)2));
        MetaAnnotation.AnnotationDeclaration[] array = declarations.toArray(new MetaAnnotation.AnnotationDeclaration[0]);
        MatcherAssert.assertThat((Object)metaAnnotation.get(), (Matcher)Matchers.sameInstance(array[0].get()));
        MatcherAssert.assertThat(metaAnnotation.getScope(), (Matcher)Matchers.sameInstance(array[0].getScope()));
        MatcherAssert.assertThat((Object)((TestHarness.CustomAnnotation)array[0].get()).value(), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)((TestHarness.CustomAnnotation)array[1].get()).value(), (Matcher)Matchers.equalTo((Object)5));
    }

    @Test
    public void testMetaProperty$genericClass$write() {
        TestHarness.GenericParent gp = new TestHarness.GenericParent();
        MetaType metaClass = MetaType.forObject(gp);
        MetaProperty<?> metaProperty = this.verifyProperty(metaClass, "root", MetaProperty.VariableScope.TYPE);
        TestHarness.Parent root = new TestHarness.Parent();
        TestHarness.GrandParent wrongRoot = new TestHarness.GrandParent();
        gp.setRoot(root);
        MatcherAssert.assertThat(metaProperty.getRawType(), (Matcher)Matchers.equalTo(TestHarness.Parent.class));
        MatcherAssert.assertThat((Object)metaProperty.getValue(gp), (Matcher)Matchers.sameInstance((Object)root));
        try {
            metaProperty.setValue(gp, wrongRoot);
            Assert.fail((String)"Property should not be updated");
        }
        catch (IllegalArgumentException e) {
            LOGGER.trace("error: " + e.getMessage());
            MatcherAssert.assertThat((Object)metaProperty.getValue(gp), (Matcher)Matchers.sameInstance((Object)root));
        }
    }

    @Test
    public void testMetaProperty$genericMethod$write() {
        TestHarness.GenericParent gp = new TestHarness.GenericParent();
        MetaType metaClass = MetaType.forObject(gp);
        MetaProperty<?> metaProperty = this.verifyProperty(metaClass, "unknown", MetaProperty.VariableScope.METHOD);
        TestHarness.Parent root = new TestHarness.Parent();
        TestHarness.GrandParent wrongRoot = new TestHarness.GrandParent();
        gp.setUnknown(root);
        MatcherAssert.assertThat(metaProperty.getRawType(), (Matcher)Matchers.equalTo(TestHarness.Parent.class));
        MatcherAssert.assertThat((Object)metaProperty.getValue(gp), (Matcher)Matchers.sameInstance((Object)root));
        try {
            metaProperty.setValue(gp, wrongRoot);
            Assert.fail((String)"Property should not be updated");
        }
        catch (IllegalArgumentException e) {
            LOGGER.trace("error: " + e.getMessage());
            MatcherAssert.assertThat((Object)metaProperty.getValue(gp), (Matcher)Matchers.sameInstance((Object)root));
        }
    }

    private MetaProperty<?> verifyProperty(MetaType<?> metaClass, String property, MetaProperty.VariableScope scope) {
        MetaProperty<?> metaProperty = metaClass.getProperty(property);
        LOGGER.trace("Property:\n" + metaProperty);
        MatcherAssert.assertThat((Object)metaProperty.isTypeVariable(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((Object)metaProperty.getTypeVariableScope()), (Matcher)Matchers.equalTo((Object)((Object)scope)));
        return metaProperty;
    }
}

