/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ldp4j.rdf.bean.meta.AnnotatedClass;
import org.ldp4j.rdf.bean.meta.AnnotatedMember;
import org.ldp4j.rdf.bean.meta.Parameterized;
import org.ldp4j.rdf.bean.util.TypeUtils;

public class AnnotatedMethod
extends AnnotatedMember<Method>
implements Parameterized {
    AnnotatedMethod(AnnotatedClass<?> metaClass, Method method) {
        super(metaClass, method);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return ((Method)this.get()).isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return ((Method)this.get()).getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return ((Method)this.get()).getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return ((Method)this.get()).getDeclaredAnnotations();
    }

    public Object invoke(Object object, Object ... arguments) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ((Method)this.get()).invoke(object, arguments);
    }

    public Class<?> getReturnType() {
        return ((Method)this.get()).getReturnType();
    }

    public Type getGenericReturnType() {
        return ((Method)this.get()).getGenericReturnType();
    }

    public List<Class<?>> getParameterTypes() {
        return Arrays.asList(((Method)this.get()).getParameterTypes());
    }

    public Class<?> getRawReturnType() {
        return this.resolveType(this, this.getGenericReturnType(), this.getReturnType());
    }

    public List<Class<?>> getRawParameterTypes() {
        ArrayList result = new ArrayList();
        Class<?>[] parameters = ((Method)this.get()).getParameterTypes();
        Type[] genericParameters = ((Method)this.get()).getGenericParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            result.add(this.resolveType(this, genericParameters[i], parameters[i]));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.dumpQualifiers(builder);
        this.dumpReturnType(builder);
        builder.append(this.getDeclaringClass());
        builder.append(".");
        this.dumpMethodTypeVariables(builder);
        builder.append(((Method)this.get()).getName());
        builder.append("(");
        this.dumpSignature(builder);
        builder.append(")");
        this.dumpExceptions(builder);
        return builder.toString();
    }

    private void dumpReturnType(StringBuilder builder) {
        builder.append(this.describe(((Method)this.get()).getReturnType(), ((Method)this.get()).getGenericReturnType(), this.getRawReturnType())).append(" ");
    }

    private void dumpQualifiers(StringBuilder builder) {
        builder.append(this.isPublic() ? "public " : (this.isPrivate() ? "private " : (this.isProtected() ? "protected " : "")));
        builder.append(this.isFinal() ? "final " : (this.isAbstract() ? "abstract " : ""));
        builder.append(this.isStatic() ? "static " : "");
    }

    private void dumpMethodTypeVariables(StringBuilder builder) {
        TypeVariable<Method>[] methodTypeParameters = ((Method)this.get()).getTypeParameters();
        if (methodTypeParameters.length > 0) {
            builder.append("<");
            for (int i = 0; i < methodTypeParameters.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(TypeUtils.toString(methodTypeParameters[i]));
            }
            builder.append(">");
        }
    }

    private void dumpExceptions(StringBuilder builder) {
        Class<?>[] exceptionTypes = ((Method)this.get()).getExceptionTypes();
        Type[] genericExceptionTypes = ((Method)this.get()).getGenericExceptionTypes();
        if (exceptionTypes.length > 0) {
            builder.append("throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                String exception = this.describe(exceptionTypes[i], genericExceptionTypes[i], exceptionTypes[i]);
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(exception);
            }
        }
    }

    private void dumpSignature(StringBuilder builder) {
        List<Class<?>> rawParameterTypes = this.getRawParameterTypes();
        List<Class<?>> parameterTypes = this.getParameterTypes();
        List<Type> genericParameterTypes = Arrays.asList(((Method)this.get()).getGenericParameterTypes());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String parameter = this.describe(parameterTypes.get(i), genericParameterTypes.get(i), rawParameterTypes.get(i));
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(parameter);
        }
    }

    private String describe(Class<?> returnType, Type genericReturnType, Class<?> rawReturnType) {
        GenericArrayType array;
        if (genericReturnType == returnType) {
            return returnType.getCanonicalName();
        }
        if (genericReturnType instanceof TypeVariable) {
            return ((TypeVariable)genericReturnType).getName();
        }
        if (genericReturnType instanceof GenericArrayType && (array = (GenericArrayType)genericReturnType).getGenericComponentType() instanceof TypeVariable) {
            return ((TypeVariable)array.getGenericComponentType()).getName().concat("[]");
        }
        return TypeUtils.toString((Type)genericReturnType) + " {" + rawReturnType.getCanonicalName() + "}";
    }

    @Override
    public List<String> parameterNames() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public TypeVariable<?> getParameter(String name) {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public Type getParameterArgument(String name) {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public Class<?> getActualParameterArgument(String name) {
        throw new UnsupportedOperationException("Method not implemented yet");
    }
}

