/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.ldp4j.rdf.bean.meta.Annotated;
import org.ldp4j.rdf.bean.meta.AnnotatedClass;
import org.ldp4j.rdf.bean.meta.Parameterized;
import org.ldp4j.rdf.bean.util.TypeUtils;

public abstract class AnnotatedMember<T extends Member>
implements Annotated<T> {
    private final T member;
    private final AnnotatedClass<?> declaringClass;

    protected AnnotatedMember(AnnotatedClass<?> declaringClass, T member) {
        this.declaringClass = declaringClass;
        this.member = member;
    }

    @Override
    public T get() {
        return this.member;
    }

    public final AnnotatedClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public final String getName() {
        return this.member.getName();
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.member.getModifiers());
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.member.getModifiers());
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.member.getModifiers());
    }

    public final boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.member.getModifiers());
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.member.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.member.getModifiers());
    }

    public final boolean isSynthetic() {
        return this.member.isSynthetic();
    }

    protected final <S extends Parameterized> Class<?> resolveType(S context, Type type, Class<?> defaultRawType) {
        Class result = defaultRawType;
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            if (variable.getGenericDeclaration() instanceof Type) {
                Class<?> argument = this.getDeclaringClass().getActualParameterArgument(variable.getName());
                if (argument != null) {
                    result = argument;
                }
            } else {
                Type[] bounds = variable.getBounds();
                if (bounds.length > 0) {
                    Type bound = bounds[0];
                    if (bound instanceof Class) {
                        result = (Class)bound;
                    } else if (bound instanceof ParameterizedType) {
                        result = (Class)((ParameterizedType)bound).getRawType();
                    } else {
                        throw new IllegalStateException(String.format("Unexpected bound type '%s' (%s)", bound.getClass().getCanonicalName(), TypeUtils.toString((Type)bound)));
                    }
                }
            }
        }
        return result;
    }
}

