/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.reflect.Type;
import org.junit.Ignore;
import org.junit.Test;
import org.ldp4j.rdf.bean.meta.AnnotatedClass;
import org.ldp4j.rdf.bean.meta.AnnotatedClassHarness;
import org.ldp4j.rdf.bean.meta.AnnotatedMethod;
import org.ldp4j.rdf.bean.meta.TestHarness;
import org.ldp4j.rdf.bean.util.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedClassTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedClassTest.class);

    @Test
    public void testAssumption$newScanner$non_generic() {
        Class[] classes = new Class[]{TestHarness.Root.class, TestHarness.GreaterGrandParent.class, TestHarness.GrandParent.class, TestHarness.Parent.class, TestHarness.Example.class};
        this.processClasses(classes);
    }

    @Test
    public void testAssumption$newScanner$generic() {
        Class[] classes = new Class[]{TestHarness.GenericRoot.class, TestHarness.GenericGreaterGrandParent.class, TestHarness.GenericGrandParent.class, TestHarness.GenericParent.class, TestHarness.GenericExample.class};
        this.processClasses(classes);
    }

    private void processClasses(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            this.processSimpleClass(clazz);
        }
    }

    private void processSimpleClass(Class<?> clazz) {
        AnnotatedClass<?> metaClass = AnnotatedClass.forClass(clazz);
        LOGGER.trace("+ {}: ", (Object)clazz.getCanonicalName());
        LOGGER.trace("\t- Regular....: {}", (Object)metaClass.toString());
        LOGGER.trace("\t- Description: {}", (Object)metaClass.describe());
    }

    private void processParameterizedClass(Class<?> clazz) {
        AnnotatedClass<?> metaClass = AnnotatedClass.forClass(clazz);
        LOGGER.trace("+ {}: ", (Object)clazz.getCanonicalName());
        LOGGER.trace("\t- Regular....: {}", (Object)metaClass.toString());
        LOGGER.trace("\t- Description: {}", (Object)metaClass.describe());
        AnnotatedMethod method = metaClass.getDeclaredMethod("get", new Class[0]);
        LOGGER.trace("+ {}: ", (Object)method);
        LOGGER.trace("\t- Return type........: {}", (Object)method.getReturnType().getCanonicalName());
        LOGGER.trace("\t- Generic return type: {}", (Object)TypeUtils.toString((Type)method.getGenericReturnType()));
        LOGGER.trace("\t- Raw return type....: {}", (Object)method.getRawReturnType().getCanonicalName());
        method = metaClass.getDeclaredMethod("array", new Class[0]);
        LOGGER.trace("+ {}: ", (Object)method);
        LOGGER.trace("\t- Return type........: {}", (Object)method.getReturnType().getCanonicalName());
        LOGGER.trace("\t- Generic return type: {}", (Object)TypeUtils.toString((Type)method.getGenericReturnType()));
        LOGGER.trace("\t- Raw return type....: {}", (Object)method.getRawReturnType().getCanonicalName());
    }

    @Test
    public void testMetaClass$simple() {
        this.processSimpleClass(AnnotatedClassHarness.BaseClass.class);
        this.processSimpleClass(AnnotatedClassHarness.Redef.class);
    }

    @Ignore(value="Case not valid in Java SE 7")
    @Test
    public void testMetaClass$parameterized() {
        this.processParameterizedClass(AnnotatedClassHarness.BaseParameterizedType.class);
        this.processParameterizedClass(AnnotatedClassHarness.MixinParameterizedClass.class);
    }
}

