/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.ldp4j.rdf.bean.meta.Annotated;
import org.ldp4j.rdf.bean.meta.AnnotatedField;
import org.ldp4j.rdf.bean.meta.AnnotatedMethod;
import org.ldp4j.rdf.bean.meta.ParameterMap;
import org.ldp4j.rdf.bean.meta.Parameterized;
import org.ldp4j.rdf.bean.util.TypeUtils;

public class AnnotatedClass<T>
implements Annotated<Class<T>>,
Parameterized {
    private final Class<T> clazz;
    private final ParameterizedType genericClass;
    private final ParameterMap parameterMap;
    private final AnnotatedClass<?> context;
    private final AnnotatedClass<?> superClass;

    private AnnotatedClass(AnnotatedClass<?> context, Class<T> clazz, ParameterizedType genericClass, ParameterMap parameterMap) {
        this.context = context;
        this.clazz = clazz;
        this.genericClass = genericClass;
        this.parameterMap = parameterMap;
        this.superClass = AnnotatedClass.superClass(this, clazz.getSuperclass(), clazz.getGenericSuperclass());
    }

    private AnnotatedClass(AnnotatedClass<?> context, Class<T> clazz, ParameterizedType genericClass) {
        this(context, clazz, genericClass, new ParameterMap(clazz.getTypeParameters(), genericClass.getActualTypeArguments(), context));
    }

    private AnnotatedClass(AnnotatedClass<?> context, Class<T> clazz) {
        this(context, clazz, null, new ParameterMap(clazz.getTypeParameters()));
    }

    private AnnotatedClass(Class<T> clazz) {
        this(null, clazz);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.clazz.isAnnotationPresent(annotationClass);
    }

    public <S extends Annotation> S getAnnotation(Class<S> annotationClass) {
        return this.clazz.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.clazz.getDeclaredAnnotations();
    }

    @Override
    public Class<T> get() {
        return this.clazz;
    }

    public Type getGenericClass() {
        return this.genericClass;
    }

    public AnnotatedClass<?> getOwnerType() {
        return this.context;
    }

    public AnnotatedClass<?> getSuperclass() {
        return this.superClass;
    }

    public AnnotatedMethod getDeclaredMethod(String name, Class<?> ... parameterTypes) {
        try {
            return new AnnotatedMethod(this, this.clazz.getDeclaredMethod(name, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public AnnotatedField getDeclaredField(String name) {
        try {
            return new AnnotatedField(this, this.clazz.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public List<AnnotatedMethod> getDeclaredMethods() {
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        for (Method method : this.clazz.getDeclaredMethods()) {
            result.add(new AnnotatedMethod(this, method));
        }
        return result;
    }

    public List<AnnotatedField> getDeclaredField() {
        ArrayList<AnnotatedField> result = new ArrayList<AnnotatedField>();
        for (Field field : this.clazz.getDeclaredFields()) {
            result.add(new AnnotatedField(this, field));
        }
        return result;
    }

    @Override
    public List<String> parameterNames() {
        return this.parameterMap.parameterNames();
    }

    @Override
    public TypeVariable<?> getParameter(String name) {
        return this.parameterMap.getParameter(name);
    }

    @Override
    public Type getParameterArgument(String name) {
        return this.parameterMap.getParameterArgument(name);
    }

    public String getSimpleName() {
        return ((Class)this.get()).getSimpleName();
    }

    public String getCanonicalName() {
        return ((Class)this.get()).getCanonicalName();
    }

    @Override
    public Class<?> getActualParameterArgument(String name) {
        return this.parameterMap.getActualParameterArgument(name);
    }

    private static <T> AnnotatedClass<T> superClass(AnnotatedClass<?> context, Class<T> clazz, Type type) {
        AnnotatedClass<T> result = null;
        if (clazz != null && clazz != Object.class) {
            result = type != null && type instanceof ParameterizedType ? new AnnotatedClass<T>(context, clazz, (ParameterizedType)type) : new AnnotatedClass<T>(context, clazz);
        }
        return result;
    }

    public static <T> AnnotatedClass<T> forClass(Class<T> clazz) {
        return new AnnotatedClass<T>(clazz);
    }

    public static <T> AnnotatedClass<T> forObject(T object) {
        return AnnotatedClass.forClass(object.getClass());
    }

    public String describe() {
        if (this.context == null) {
            if (this.superClass == null) {
                return this.toString(false);
            }
            return this.toString(false) + " extends " + this.superClass.describe();
        }
        if (this.superClass == null) {
            return this.toString(true);
        }
        return this.toString(true) + " extends " + this.superClass.describe();
    }

    private String toString(boolean resolve) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.clazz.getCanonicalName());
        TypeVariable<Class<T>>[] typeParameters = this.clazz.getTypeParameters();
        if (typeParameters.length > 0) {
            builder.append("<");
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable<Class<T>> typeParameter;
                if (i > 0) {
                    builder.append(", ");
                }
                Type parameter = typeParameter = typeParameters[i];
                if (resolve) {
                    parameter = this.getParameterArgument(typeParameter.getName());
                }
                builder.append(TypeUtils.toString(parameter));
            }
            builder.append(">");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(false);
    }
}

