/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.meta;

import java.lang.reflect.Method;
import java.util.List;
import org.ldp4j.rdf.bean.meta.AnnotatedClass;
import org.ldp4j.rdf.bean.meta.AnnotatedMethod;
import org.ldp4j.rdf.bean.util.BeanUtils;

public final class AnnotatedBeanUtils {
    private AnnotatedBeanUtils() {
    }

    public static boolean isGetter(AnnotatedMethod method) {
        return BeanUtils.isGetter((Method)((Method)method.get()));
    }

    public static AnnotatedMethod getSetter(AnnotatedMethod getter) {
        return AnnotatedBeanUtils.getSetter(getter.getDeclaringClass(), AnnotatedBeanUtils.getPropertyName(getter), getter.getReturnType());
    }

    private static AnnotatedMethod getSetter(AnnotatedClass<?> clazz, String propertyName, Class<?> propertyType) {
        String setterName = "set" + BeanUtils.capitalize((String)propertyName);
        for (AnnotatedMethod candidate : clazz.getDeclaredMethods()) {
            List<Class<?>> parameters = candidate.getRawParameterTypes();
            if (!candidate.isPublic() || candidate.getReturnType() != Void.TYPE || !candidate.getName().equals(setterName) || parameters.size() != 1 || propertyType != parameters.get(0)) continue;
            return candidate;
        }
        return null;
    }

    public static AnnotatedMethod findSetter(AnnotatedClass<?> clazz, String propertyName, Class<?> propertyType) {
        AnnotatedMethod result = null;
        for (AnnotatedClass<?> ctx = clazz; ctx != null && result == null; ctx = ctx.getSuperclass()) {
            result = AnnotatedBeanUtils.getSetter(ctx, propertyName, propertyType);
        }
        return result;
    }

    public static String getPropertyName(AnnotatedMethod method) {
        return BeanUtils.getPropertyName((Method)((Method)method.get()));
    }
}

