/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.ldp4j.rdf.bean.impl.TypeSupport;

public class TypeSupportTest {
    private Class<?>[] primitives = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE};
    private Class<?>[] wrappers = new Class[]{Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class};

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testPrimitives() throws Exception {
        for (Class<?> clazz : this.primitives) {
            MatcherAssert.assertThat((Object)TypeSupport.isPrimitive(clazz), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)TypeSupport.isLiteral(clazz), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)TypeSupport.isAggregation(clazz), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)TypeSupport.isRepeatable(clazz), (Matcher)Matchers.equalTo((Object)false));
        }
        for (Class<?> clazz : this.wrappers) {
            MatcherAssert.assertThat((Object)TypeSupport.isPrimitive(clazz), (Matcher)Matchers.equalTo((Object)false));
        }
    }

    @Test
    public void testWrappers() throws Exception {
        for (Class<?> clazz : this.wrappers) {
            MatcherAssert.assertThat((Object)TypeSupport.isWrapper(clazz), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)TypeSupport.isLiteral(clazz), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)TypeSupport.isAggregation(clazz), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)TypeSupport.isRepeatable(clazz), (Matcher)Matchers.equalTo((Object)false));
        }
        for (Class<?> clazz : this.primitives) {
            MatcherAssert.assertThat((Object)TypeSupport.isWrapper(clazz), (Matcher)Matchers.equalTo((Object)false));
        }
    }

    @Test
    public void testStrings() throws Exception {
        MatcherAssert.assertThat((Object)TypeSupport.isWrapper(CharSequence.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isLiteral(CharSequence.class), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)TypeSupport.isAggregation(CharSequence.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isRepeatable(CharSequence.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isWrapper(String.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isLiteral(String.class), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)TypeSupport.isAggregation(String.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isRepeatable(String.class), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testCollections$List() throws Exception {
        MatcherAssert.assertThat((Object)TypeSupport.isWrapper(List.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isLiteral(List.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isAggregation(List.class), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)TypeSupport.isRepeatable(List.class), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testCollections$Set() throws Exception {
        MatcherAssert.assertThat((Object)TypeSupport.isWrapper(Set.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isLiteral(Set.class), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)TypeSupport.isAggregation(Set.class), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)TypeSupport.isRepeatable(Set.class), (Matcher)Matchers.equalTo((Object)false));
    }
}

