/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.impl.EnumerationHelper;
import org.ldp4j.rdf.bean.impl.EnumerationHelperTest;

public class EnumerationHelperTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testNewInstance$valid() throws Exception {
        EnumerationHelper sut = EnumerationHelper.newInstance(ValidEnumeration.class);
        MatcherAssert.assertThat((Object)sut, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)sut.getEnumeratedClass(), (Matcher)Matchers.is(ValidEnumeration.class));
        MatcherAssert.assertThat((Object)sut.names(), (Matcher)Matchers.equalTo(ValidEnumeration.NAMES));
        MatcherAssert.assertThat((Object)sut.name((Object)ValidEnumeration.ONE), (Matcher)Matchers.equalTo((Object)ValidEnumeration.ONE.name));
        MatcherAssert.assertThat((Object)sut.name((Object)ValidEnumeration.TWO), (Matcher)Matchers.equalTo((Object)ValidEnumeration.TWO.name));
        MatcherAssert.assertThat((Object)sut.valueOf(ValidEnumeration.ONE.name), (Matcher)Matchers.equalTo((Object)ValidEnumeration.ONE));
        MatcherAssert.assertThat((Object)sut.valueOf(ValidEnumeration.TWO.name), (Matcher)Matchers.equalTo((Object)ValidEnumeration.TWO));
        MatcherAssert.assertThat((Object)sut.values(), (Matcher)Matchers.equalTo(ValidEnumeration.VALUES));
        try {
            sut.valueOf("other");
            Assert.fail((String)"Invalid names should make the helper fail");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"'other'"));
        }
    }

    @Test
    public void testNewInstance$invalid$names() throws Exception {
        try {
            EnumerationHelper.newInstance(Invalid.Names.Missing.class);
            Assert.fail((String)("Class should fail: " + Invalid.Names.Missing.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Names.WrongReturn.NoParameterizedType.class);
            Assert.fail((String)("Class should fail: " + Invalid.Names.WrongReturn.NoParameterizedType.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Names.WrongReturn.NoSet.class);
            Assert.fail((String)("Class should fail: " + Invalid.Names.WrongReturn.NoSet.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Names.WrongReturn.NoString.class);
            Assert.fail((String)("Class should fail: " + Invalid.Names.WrongReturn.NoString.class));
        }
        catch (InvalidDefinitionException invalidDefinitionException) {
            // empty catch block
        }
    }

    @Test
    public void testNewInstance$invalid$name() throws Exception {
        try {
            EnumerationHelper.newInstance(Invalid.Name.Missing.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.Missing.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Name.WrongModifiers.abstract.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.WrongModifiers.abstract.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Name.WrongModifiers.static.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.WrongModifiers.static.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Name.WrongModifiers.protected.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.WrongModifiers.protected.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Name.WrongModifiers.private.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.WrongModifiers.private.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Name.WrongModifiers.default.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.WrongModifiers.default.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.Name.WrongReturn.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.WrongReturn.class));
        }
        catch (InvalidDefinitionException invalidDefinitionException) {
            // empty catch block
        }
    }

    @Test
    public void testNewInstance$invalid$fromName() throws Exception {
        try {
            EnumerationHelper.newInstance(Invalid.FromName.Missing.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.Missing.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.FromName.WrongParam.class);
            Assert.fail((String)("Class should fail: " + Invalid.FromName.WrongParam.class));
        }
        catch (InvalidDefinitionException e) {
            // empty catch block
        }
        try {
            EnumerationHelper.newInstance(Invalid.FromName.WrongReturn.class);
            Assert.fail((String)("Class should fail: " + Invalid.Name.WrongReturn.class));
        }
        catch (InvalidDefinitionException invalidDefinitionException) {
            // empty catch block
        }
    }

    public static class ValidEnumeration {
        protected static final Set<String> NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ONE", "TWO")));
        protected static final ValidEnumeration ONE = new ValidEnumeration("ONE");
        protected static final ValidEnumeration TWO = new ValidEnumeration("TWO");
        protected static final Set<ValidEnumeration> VALUES = Collections.unmodifiableSet(new HashSet<ValidEnumeration>(Arrays.asList(ONE, TWO)));
        private final String name;

        private ValidEnumeration(String name) {
            this.name = name;
        }

        public static Set<String> names() {
            return NAMES;
        }

        public String name() {
            return this.name;
        }

        public static ValidEnumeration valueOf(String name) {
            if (ValidEnumeration.ONE.name.equals(name)) {
                return ONE;
            }
            if (ValidEnumeration.TWO.name.equals(name)) {
                return TWO;
            }
            throw new IllegalArgumentException("Unknown name '" + name + "'");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValidEnumeration)) {
                return false;
            }
            ValidEnumeration other = (ValidEnumeration)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Example {
        ONE,
        TWO;

    }
}

