/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import fallback.SimpleNamedFallbackType;
import fallback.SimpleUnnamedFallbackType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.ldp4j.rdf.bean.ComplexNamedFallbackType;
import org.ldp4j.rdf.bean.ComplexUnnamedFallbackType;
import org.ldp4j.rdf.bean.InvalidDefinitionException;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.TypeRegistry;
import org.ldp4j.rdf.bean.example.services.Control;
import org.ldp4j.rdf.bean.example.services.Service;
import org.ldp4j.rdf.bean.impl.DefinitionLoader;
import org.ldp4j.rdf.bean.impl.TransactionalTypeRegistry;
import org.ldp4j.rdf.bean.impl.TypeManager;
import org.ldp4j.rdf.bean.impl.TypeManagerImpl;

@org.ldp4j.rdf.bean.annotations.Type(name="MyType", namespace="http://www.example.org/vocab#")
public class DefinitionLoaderTest {
    public static final String NAMESPACE = "http://www.example.org/vocab#";
    public static final String NAME = "MyType";
    private TypeManagerImpl manager;

    @Before
    public void setUp() {
        this.manager = new TypeManagerImpl((TypeRegistry)new TransactionalTypeRegistry());
    }

    @Test(expected=InvalidDefinitionException.class)
    public void testForClass$orphanClass$nullNamespace() throws Exception {
        Class<?> orphanClass = Class.forName("NullNamespaceOrphanType");
        DefinitionLoader.loadType(orphanClass, (TypeManager)this.manager);
    }

    @Test(expected=InvalidDefinitionException.class)
    public void testForClass$orphanClass$emptyNamespace() throws Exception {
        Class<?> orphanClass = Class.forName("EmptyNamespaceOrphanType");
        DefinitionLoader.loadType(orphanClass, (TypeManager)this.manager);
    }

    @Test
    public void testForClass$unnamed$fallback$simple() throws Exception {
        Type sut = DefinitionLoader.loadType(SimpleUnnamedFallbackType.class, (TypeManager)this.manager);
        MatcherAssert.assertThat((Object)sut.getNamespace(), (Matcher)Matchers.equalTo((Object)"http://fallback/"));
        MatcherAssert.assertThat((Object)sut.getName(), (Matcher)Matchers.equalTo((Object)SimpleUnnamedFallbackType.class.getSimpleName()));
    }

    @Test
    public void testForClass$unnamed$fallback$complex() throws Exception {
        Type sut = DefinitionLoader.loadType(ComplexUnnamedFallbackType.class, (TypeManager)this.manager);
        MatcherAssert.assertThat((Object)sut.getNamespace(), (Matcher)Matchers.equalTo((Object)"http://ldp4j.org/rdf/bean/"));
        MatcherAssert.assertThat((Object)sut.getName(), (Matcher)Matchers.equalTo((Object)ComplexUnnamedFallbackType.class.getSimpleName()));
    }

    @Test
    public void testForClass$named$fallback$simple() throws Exception {
        Type sut = DefinitionLoader.loadType(SimpleNamedFallbackType.class, (TypeManager)this.manager);
        MatcherAssert.assertThat((Object)sut.getNamespace(), (Matcher)Matchers.equalTo((Object)"http://fallback/"));
        MatcherAssert.assertThat((Object)sut.getName(), (Matcher)Matchers.equalTo((Object)"Type"));
    }

    @Test
    public void testForClass$named$fallback$complex() throws Exception {
        Type sut = DefinitionLoader.loadType(ComplexNamedFallbackType.class, (TypeManager)this.manager);
        MatcherAssert.assertThat((Object)sut.getNamespace(), (Matcher)Matchers.equalTo((Object)"http://ldp4j.org/rdf/bean/"));
        MatcherAssert.assertThat((Object)sut.getName(), (Matcher)Matchers.equalTo((Object)"Type"));
    }

    @Test
    public void testForClass$unnamed$vocabularyNamespace() throws Exception {
        Type sut = DefinitionLoader.loadType(Service.class, (TypeManager)this.manager);
        MatcherAssert.assertThat((Object)sut.getNamespace(), (Matcher)Matchers.equalTo((Object)"http://delicias.dia.fi.upm.es/alm-istack/transactions/services#"));
        MatcherAssert.assertThat((Object)sut.getName(), (Matcher)Matchers.equalTo((Object)Service.class.getSimpleName()));
    }

    @Test
    public void testForClass$named$vocabularyNamespace() throws Exception {
        Type sut = DefinitionLoader.loadType(Control.class, (TypeManager)this.manager);
        MatcherAssert.assertThat((Object)sut.getNamespace(), (Matcher)Matchers.equalTo((Object)"http://delicias.dia.fi.upm.es/alm-istack/transactions/services#"));
        MatcherAssert.assertThat((Object)sut.getName(), (Matcher)Matchers.equalTo((Object)"HypermediaControl"));
    }

    @Test
    public void testForClass$defined() throws Exception {
        Type sut = DefinitionLoader.loadType(DefinitionLoaderTest.class, (TypeManager)this.manager);
        MatcherAssert.assertThat((Object)sut.getNamespace(), (Matcher)Matchers.equalTo((Object)NAMESPACE));
        MatcherAssert.assertThat((Object)sut.getName(), (Matcher)Matchers.equalTo((Object)NAME));
    }
}

