/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.example.transactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ldp4j.rdf.bean.Category;
import org.ldp4j.rdf.bean.annotations.Type;
import org.ldp4j.rdf.bean.example.services.Operation;

@Type(category=Category.ENUMERATION)
public class TransactionOperation
extends Operation {
    private static final String COMMIT_NAME = "Commit";
    private static final String ENROLL_NAME = "Enroll";
    private static final String ROLLBACK_NAME = "Rollback";
    private static final String NOTIFY_NAME = "Notify";
    public static final TransactionOperation ENROLL = new TransactionOperation("Enroll");
    public static final TransactionOperation COMMIT = new TransactionOperation("Commit");
    public static final TransactionOperation ROLLBACK = new TransactionOperation("Rollback");
    public static final TransactionOperation NOTIFY = new TransactionOperation("Notify");
    private static final Set<String> NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ENROLL.name(), COMMIT.name(), ROLLBACK.name(), NOTIFY.name())));
    private final String name;

    private TransactionOperation(String name) {
        this.name = name;
    }

    public static Set<String> names() {
        return NAMES;
    }

    public String name() {
        return this.name;
    }

    public static TransactionOperation valueOf(String name) {
        if (TransactionOperation.ENROLL.name.equals(name)) {
            return ENROLL;
        }
        if (TransactionOperation.COMMIT.name.equals(name)) {
            return COMMIT;
        }
        if (TransactionOperation.ROLLBACK.name.equals(name)) {
            return ROLLBACK;
        }
        if (TransactionOperation.NOTIFY.name.equals(name)) {
            return NOTIFY;
        }
        throw new IllegalArgumentException("Unknown name '" + name + "'");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionOperation)) {
            return false;
        }
        TransactionOperation other = (TransactionOperation)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

