/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.example;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.bean.JARBContext;
import org.ldp4j.rdf.bean.NamingPolicy;
import org.ldp4j.rdf.bean.example.ClassDescription;
import org.ldp4j.rdf.bean.example.services.Controller;
import org.ldp4j.rdf.bean.example.transactions.Transaction;
import org.ldp4j.rdf.bean.example.transactions.TransactionCapabilities;
import org.ldp4j.rdf.bean.example.transactions.TransactionControl;
import org.ldp4j.rdf.bean.example.transactions.TransactionOperation;
import org.ldp4j.rdf.util.RDFModelDSL;
import org.ldp4j.rdf.util.TripleSet;

public class ImplementationDriver {
    @Test
    public void testAssumption$overridedMethodExecutionByReflection() throws Exception {
        Child child = new Child();
        child.setValues(new HashSet());
        Method declaredMethod = Super.class.getDeclaredMethod("getValues", new Class[0]);
        Object result = declaredMethod.invoke((Object)child, new Object[0]);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(Set.class));
        MatcherAssert.assertThat((Object)((Set)result), (Matcher)Matchers.contains((Object[])new Object[]{"ME"}));
    }

    @Test
    public void testAssumption$overridedMethodIntrospection() throws Exception {
        ClassDescription<Overriding> cl = ClassDescription.newInstance(Overriding.class);
        System.err.println(cl.recursive(true).traverseClasses(false).traverseInterfaces(true).traverseSuperclass(true).ignoreDefaultMethods(true).ignoreDefaultSuperclass(true).excludePublicElementsFromDeclared(true).toString());
        this.introspect(Child.class, "getValues", new Class[0]);
        this.introspect(Child.class, "setValues", Set.class);
        this.introspect(Overriding.class, "getRoot", new Class[0]);
        this.introspect(Overriding.class, "setRoot", Root.class);
    }

    private void introspect(Class<?> clazz, String method, Class<?> ... params) {
        System.err.printf("Looking for %s(%s):%n", method, Arrays.asList(params));
        Class<?> c = clazz;
        while (c != null) {
            try {
                Method m = c.getDeclaredMethod(method, params);
                this.printMethod(m);
            }
            catch (Exception e) {
                System.err.println("Not found in '" + c.getCanonicalName() + "'...");
            }
            if ((c = c.getSuperclass()) != Object.class) continue;
            c = null;
        }
    }

    private void printMethod(Method method) {
        System.err.printf("%s: %s %s %s(%s) {bridge=%s,synthetic=%s,varargs=%s}%n", method.getDeclaringClass().getCanonicalName(), Modifier.toString(method.getModifiers()), method.getGenericReturnType(), method.getName(), Arrays.asList(method.getGenericParameterTypes()), method.isBridge(), method.isSynthetic(), method.isVarArgs());
    }

    @Test
    public void shouldWork() {
        Transaction transaction = this.getTransaction();
        JARBContext context = JARBContext.newInstance((NamingPolicy)new CustomDeploymentPolicy());
        TripleSet triples = context.deflate((Object)transaction);
        Resource identity = context.getIdentity((Object)transaction);
        System.err.printf("- Main individual: %s%n- Serialization:%n%s%n", identity, triples);
        Transaction inflate = (Transaction)context.inflate(identity, triples, Transaction.class);
        System.err.printf("- Inflated: %s%n", inflate);
    }

    private Transaction getTransaction() {
        Controller controller = new Controller();
        TransactionControl control1 = new TransactionControl();
        control1.setOperation(TransactionOperation.ENROLL);
        control1.setController(controller);
        TransactionControl control2 = new TransactionControl();
        control2.setOperation(TransactionOperation.COMMIT);
        control2.setController(new Controller());
        HashSet<TransactionControl> controls = new HashSet<TransactionControl>();
        controls.add(control1);
        controls.add(control2);
        TransactionCapabilities capabilities = new TransactionCapabilities();
        capabilities.setControls(controls);
        Transaction t = new Transaction();
        t.setCapabilities(capabilities);
        return t;
    }

    @Test
    public void testAssumption$genericRequiredSafeTypeCheck() throws Exception {
        TransactionControl control2 = new TransactionControl();
        control2.setOperation(TransactionOperation.COMMIT);
        control2.setController(new Controller());
        MatcherAssert.assertThat(control2.getOperation(), (Matcher)Matchers.equalTo((Object)TransactionOperation.COMMIT));
    }

    public class CustomDeploymentPolicy
    implements NamingPolicy {
        private long ctr = 0L;

        public <T> Resource<?> createIdentity(T object) {
            return RDFModelDSL.uriRef((URI)URI.create(String.format("urn:%03X:%08X", this.ctr++, System.identityHashCode(object))));
        }

        public <T> Resource<?> enumeratedIdentity(T object) {
            if (object instanceof TransactionOperation) {
                TransactionOperation to = (TransactionOperation)object;
                return RDFModelDSL.uriRef((String)("http://delicias.dia.fi.upm.es/alm-istack/transactions/transactions#" + to.name()));
            }
            throw new IllegalStateException("Unknown enumerated object '" + object + "'");
        }

        public <T> T resolveEnumerated(Resource<?> identity, Class<? extends T> clazz) {
            throw new UnsupportedOperationException("Method not implemented yet");
        }
    }

    public static class Overriding
    extends Overridable<Leaf> {
        @Override
        public void setRoot(Leaf root) {
            super.setRoot(root);
        }

        @Override
        public Leaf getRoot() {
            return (Leaf)super.getRoot();
        }
    }

    public static class Overridable<T extends Root> {
        private T root;

        public void setRoot(T root) {
            this.root = root;
        }

        public T getRoot() {
            return this.root;
        }
    }

    public static class Leaf
    extends Root {
    }

    public static class Root {
    }

    public static class Child
    extends Super<String> {
        @Override
        public Set<String> getValues() {
            Set<String> values = super.getValues();
            values.add("ME");
            return values;
        }
    }

    public static class Super<T> {
        private Set<T> values;

        public void setValues(Set<T> values) {
            this.values = values;
        }

        public Set<T> getValues() {
            return this.values;
        }
    }
}

