/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.example;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ClassDescription<T> {
    private final Class<T> type;
    private final ClassWrapper classWrapper;

    private ClassDescription(Class<T> type) {
        this.type = type;
        this.classWrapper = new ClassWrapper(type);
    }

    public ClassDescription<T> excludePublicElementsFromDeclared(boolean excludePublicElementsFromDeclared) {
        this.classWrapper.excludePublicElementsFromDeclared(excludePublicElementsFromDeclared);
        return this;
    }

    public ClassDescription<T> ignoreDefaultSuperclass(boolean ignoreDefaultSuperclass) {
        this.classWrapper.ignoreDefaultSuperclass(ignoreDefaultSuperclass);
        return this;
    }

    public ClassDescription<T> ignoreDefaultMethods(boolean ignoreDefaultMethods) {
        this.classWrapper.ignoreDefaultMethods(ignoreDefaultMethods);
        return this;
    }

    public ClassDescription<T> traverseInterfaces(boolean traverseInterfaces) {
        this.classWrapper.traverseInterfaces(traverseInterfaces);
        return this;
    }

    public ClassDescription<T> traverseSuperclass(boolean traverseSuperclass) {
        this.classWrapper.traverseSuperclass(traverseSuperclass);
        return this;
    }

    public ClassDescription<T> recursive(boolean recursive) {
        this.classWrapper.recursive(recursive);
        return this;
    }

    public ClassDescription<T> traverseClasses(boolean traverseClasses) {
        this.classWrapper.traverseClasses(traverseClasses);
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String toString() {
        return this.classWrapper.toString();
    }

    public static <T> ClassDescription<T> newInstance(Class<T> type) {
        return new ClassDescription<T>(type);
    }

    private static class AnnotatedElementWrapper
    extends Wrapper<AnnotatedElement> {
        public AnnotatedElementWrapper(AnnotatedElement element) {
            super(element);
        }

        @Override
        protected IPrinter<AnnotatedElement> createPrinter() {
            return new AnnotatedElementPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
        }
    }

    private static class MemberWrapper
    extends Wrapper<Member> {
        public MemberWrapper(Member element) {
            super(element);
        }

        @Override
        protected IPrinter<Member> createPrinter() {
            return new MemberPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
        }
    }

    private static class GenericDeclarationWrapper
    extends Wrapper<GenericDeclaration> {
        public GenericDeclarationWrapper(GenericDeclaration element) {
            super(element);
        }

        @Override
        protected IPrinter<GenericDeclaration> createPrinter() {
            return new GenericDeclarationPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
        }
    }

    private static class ClassWrapper
    extends TypeWrapper<Class<?>> {
        private boolean recursive = false;
        private boolean traverseInterfaces = false;
        private boolean ignoreDefaultMethods = false;
        private boolean ignoreDefaultSuperclass = false;
        private boolean traverseSuperclass = false;
        private boolean traverseClasses = false;

        public ClassWrapper(Class<?> clazz) {
            super(clazz);
        }

        public ClassWrapper recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public ClassWrapper ignoreDefaultSuperclass(boolean ignoreDefaultSuperclass) {
            this.ignoreDefaultSuperclass = ignoreDefaultSuperclass;
            return this;
        }

        public ClassWrapper ignoreDefaultMethods(boolean ignoreDefaultMethods) {
            this.ignoreDefaultMethods = ignoreDefaultMethods;
            return this;
        }

        public ClassWrapper traverseInterfaces(boolean traverseInterfaces) {
            this.traverseInterfaces = traverseInterfaces;
            return this;
        }

        public ClassWrapper traverseSuperclass(boolean traverseSuperclass) {
            this.traverseSuperclass = traverseSuperclass;
            return this;
        }

        public ClassWrapper traverseClasses(boolean traverseClasses) {
            this.traverseClasses = traverseClasses;
            return this;
        }

        public ClassWrapper excludePublicElementsFromDeclared(boolean excludePublicElementsFromDeclared) {
            super.excludePublicElementsFromDeclared(excludePublicElementsFromDeclared);
            return this;
        }

        @Override
        protected IPrinter<Class<?>> createPrinter() {
            return new ClassPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared()).ignoreDefaultMethods(this.ignoreDefaultMethods).ignoreDefaultSuperclass(this.ignoreDefaultSuperclass).recursive(this.recursive).traverseInterfaces(this.traverseInterfaces).traverseClasses(this.traverseClasses).traverseSuperclass(this.traverseSuperclass);
        }
    }

    private static class ConstructorWrapper
    extends Wrapper<Constructor<?>> {
        public ConstructorWrapper(Constructor<?> constructor) {
            super(constructor);
        }

        @Override
        protected IPrinter<Constructor<?>> createPrinter() {
            return new ConstructorPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
        }
    }

    private static class MethodWrapper
    extends Wrapper<Method> {
        public MethodWrapper(Method method) {
            super(method);
        }

        public boolean isFromKernel() {
            return ((Method)this.getElement()).getDeclaringClass().equals(Object.class);
        }

        @Override
        protected IPrinter<Method> createPrinter() {
            return new MethodPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
        }
    }

    private static class FieldWrapper
    extends Wrapper<Field> {
        public FieldWrapper(Field field) {
            super(field);
        }

        @Override
        protected final IPrinter<Field> createPrinter() {
            return new FieldPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
        }
    }

    private static class AnnotationWrapper
    extends Wrapper<Annotation> {
        public AnnotationWrapper(Annotation annotation) {
            super(annotation);
        }

        @Override
        protected final IPrinter<Annotation> createPrinter() {
            return new AnnotationPrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
        }
    }

    private static class TypeWrapper<T extends Type>
    extends Wrapper<T> {
        @Override
        protected IPrinter<T> createPrinter() {
            AbstractPrinter result;
            Type element = (Type)this.getElement();
            if (ParameterizedType.class.isInstance(element)) {
                AbstractPrinter raw;
                result = raw = new ParameterizedTypePrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
            } else if (TypeVariable.class.isInstance(element)) {
                AbstractPrinter raw = new TypeVariablePrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
                result = raw;
            } else if (WildcardType.class.isInstance(element)) {
                AbstractPrinter raw = new WildcardTypePrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
                result = raw;
            } else if (GenericArrayType.class.isInstance(element)) {
                AbstractPrinter raw = new GenericArrayTypePrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
                result = raw;
            } else {
                AbstractPrinter raw = new DefaultTypePrinter().excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
                result = raw;
            }
            return result;
        }

        public TypeWrapper(T type) {
            super(type);
        }
    }

    private static abstract class Wrapper<E>
    implements IWrapper<E> {
        private final E element;
        private boolean excludePublicElementsFromDeclared = false;

        public Wrapper(E element) {
            this.element = element;
        }

        @Override
        public final E getElement() {
            return this.element;
        }

        public Wrapper<E> excludePublicElementsFromDeclared(boolean excludePublicElementsFromDeclared) {
            this.excludePublicElementsFromDeclared = excludePublicElementsFromDeclared;
            return this;
        }

        public boolean excludePublicElementsFromDeclared() {
            return this.excludePublicElementsFromDeclared;
        }

        public final String toString() {
            if (this.getElement() == null) {
                return null;
            }
            return this.createPrinter().toString(this.getElement());
        }

        protected abstract IPrinter<E> createPrinter();
    }

    private static interface IWrapper<E> {
        public E getElement();
    }

    private static class ClassPrinter
    extends AbstractPrinter<Class<?>> {
        private boolean ignoreDefaultSuperclass;
        private boolean ignoreDefaultMethods;
        private boolean recursive;
        private boolean traverseInterfaces;
        private boolean traverseClasses;
        private boolean traverseSuperclass;

        public ClassPrinter excludePublicElementsFromDeclared(boolean excludePublicElementsFromDeclared) {
            super.excludePublicElementsFromDeclared(excludePublicElementsFromDeclared);
            return this;
        }

        public ClassPrinter ignoreDefaultSuperclass(boolean ignoreDefaultSuperclass) {
            this.ignoreDefaultSuperclass = ignoreDefaultSuperclass;
            return this;
        }

        public ClassPrinter ignoreDefaultMethods(boolean ignoreDefaultMethods) {
            this.ignoreDefaultMethods = ignoreDefaultMethods;
            return this;
        }

        public ClassPrinter traverseInterfaces(boolean traverseInterfaces) {
            this.traverseInterfaces = traverseInterfaces;
            return this;
        }

        public ClassPrinter traverseClasses(boolean traverseClasses) {
            this.traverseClasses = traverseClasses;
            return this;
        }

        public ClassPrinter traverseSuperclass(boolean traverseSuperclass) {
            this.traverseSuperclass = traverseSuperclass;
            return this;
        }

        public ClassPrinter recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        @Override
        protected void processType(Class<?> type) {
            super.addTitle("Class");
            super.addField("name", type.getName());
            super.addField("package", type.getPackage());
            super.addField("simple name", type.getSimpleName());
            super.addField("canonical name", type.getCanonicalName());
            super.addField("interface", type.isInterface());
            super.addField("annotation", type.isAnnotation());
            super.addField("primitive", type.isPrimitive());
            super.addField("enum", type.isEnum());
            super.addMultiField("enum constants", type.getEnumConstants());
            super.addField("array", type.isArray());
            super.addField("component type", type.getComponentType());
            super.addField("anonymous class", type.isAnonymousClass());
            super.addField("local class", type.isLocalClass());
            super.addField("member class", type.isMemberClass());
            super.addField("declaring class", type.getDeclaringClass());
            super.addField("modifiers", Modifier.toString(type.getModifiers()));
            super.addField("synthetic", type.isSynthetic());
            super.addField("enclosing method", type.getEnclosingMethod());
            super.addField("enclosing constructor", type.getEnclosingConstructor());
            super.addField("enclosing class", type.getEnclosingClass());
            super.addBlockField("generic declaration", this.wrapElementAs(type, GenericDeclaration.class));
            super.addBlockField("annotated element", this.wrapElementAs(type, AnnotatedElement.class));
            Class<?> superclass = type.getSuperclass();
            if (!(superclass == null || superclass.equals(Object.class) && this.ignoreDefaultSuperclass)) {
                if (this.traverseSuperclass) {
                    super.addBlockField("superclass", this.wrap(type.getSuperclass()));
                } else {
                    super.addField("superclass", type.getSuperclass());
                }
            }
            super.addBlockField("generic superclass", this.wrapElement(type.getGenericSuperclass()));
            if (this.traverseInterfaces) {
                super.addMultiField("interfaces", this.wrap(type.getInterfaces()));
            } else {
                super.addMultiField("interfaces", type.getInterfaces());
            }
            super.addMultiField("generic interfaces", this.wrapElementArray(type.getGenericInterfaces()));
            String suffix = "";
            String prefix = "";
            if (this.excludePublicElementsFromDeclared()) {
                suffix = " (excluding public)";
                prefix = "public ";
            }
            Object[] classes = type.getClasses();
            List<Class<?>> declaredClasses = this.publicElementFilter(classes, type.getDeclaredClasses(), this.excludePublicElementsFromDeclared());
            if (this.traverseClasses) {
                super.addMultiField(prefix + "classes", this.wrap((Class<?>[])classes));
                super.addMultiField("declared classes" + suffix, this.wrap(declaredClasses.toArray(new Class[0])));
            } else {
                super.addMultiField(prefix + "classes", classes);
                super.addMultiField("declared classes" + suffix, declaredClasses);
            }
            Object[] fields = type.getFields();
            super.addMultiField(prefix + "fields", this.wrapElementArray(fields));
            super.addMultiField("declared fields" + suffix, this.wrapElements(this.publicElementFilter(fields, type.getDeclaredFields(), this.excludePublicElementsFromDeclared())));
            Method[] methods = type.getMethods();
            String subprefix = "";
            if (this.ignoreDefaultMethods) {
                subprefix = "non-default ";
            }
            super.addMultiField(prefix + subprefix + "methods", this.defaultMethodFilter(Arrays.asList(methods), this.ignoreDefaultMethods));
            super.addMultiField(prefix + subprefix + "declared methods" + suffix, this.defaultMethodFilter(this.publicElementFilter(methods, type.getDeclaredMethods(), this.excludePublicElementsFromDeclared()), this.ignoreDefaultMethods));
            Object[] constructors = type.getConstructors();
            super.addMultiField(prefix + "constructors", this.wrapElementArray(constructors));
            super.addMultiField("declared constructors" + suffix, this.wrapElements(this.publicElementFilter(constructors, type.getDeclaredConstructors(), this.excludePublicElementsFromDeclared())));
        }

        private List<ClassWrapper> wrap(Class<?>[] classes) {
            ArrayList<ClassWrapper> wrappedClasses = new ArrayList<ClassWrapper>();
            for (Class<?> w : classes) {
                wrappedClasses.add(this.wrap(w));
            }
            return wrappedClasses;
        }

        private ClassWrapper wrap(Class<?> clazz) {
            ClassWrapper e = new ClassWrapper(clazz).recursive(this.recursive).excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared()).ignoreDefaultMethods(this.ignoreDefaultMethods).ignoreDefaultSuperclass(this.ignoreDefaultSuperclass).traverseClasses(this.traverseClasses && this.recursive).traverseInterfaces(this.traverseInterfaces && this.recursive).traverseSuperclass(this.traverseSuperclass && this.recursive);
            return e;
        }

        private <T> List<T> publicElementFilter(T[] publicElements, T[] declaredElements, boolean filter) {
            ArrayList<T> nonPublicClasses = new ArrayList<T>(Arrays.asList(declaredElements));
            if (filter) {
                nonPublicClasses.removeAll(Arrays.asList(publicElements));
            }
            return nonPublicClasses;
        }

        private List<Wrapper<?>> defaultMethodFilter(List<Method> methods, boolean filter) {
            ArrayList result = new ArrayList();
            for (Method method : methods) {
                MethodWrapper w = new MethodWrapper(method);
                w.excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
                if (w.isFromKernel() && filter) continue;
                result.add(w);
            }
            return result;
        }
    }

    private static class ConstructorPrinter
    extends AbstractPrinter<Constructor<?>> {
        private ConstructorPrinter() {
        }

        @Override
        protected void processType(Constructor<?> type) {
            super.addTitle("Constructor");
            super.addBlockField("member", this.wrapElementAs(type, Member.class));
            super.addBlockField("generic declaration", this.wrapElementAs(type, GenericDeclaration.class));
            super.addBlockField("annotated element", this.wrapElementAs(type, AnnotatedElement.class));
            super.addField("accessible", type.isAccessible());
            super.addMultiField("parameter types", type.getParameterTypes());
            super.addMultiField("generic parameter types", type.getGenericParameterTypes());
            Annotation[][] parameterAnnotations = type.getParameterAnnotations();
            ArrayList<String> annots = new ArrayList<String>();
            for (Object[] objectArray : parameterAnnotations) {
                annots.add(Arrays.toString(objectArray));
            }
            super.addMultiField("parameter annotations", annots);
            super.addField("var args", type.isVarArgs());
            super.addMultiField("exception types", type.getExceptionTypes());
            super.addMultiField("generic exception types", type.getGenericExceptionTypes());
        }
    }

    private static class MethodPrinter
    extends AbstractPrinter<Method> {
        private MethodPrinter() {
        }

        @Override
        protected void processType(Method type) {
            super.addTitle("Method");
            super.addBlockField("member", this.wrapElementAs(type, Member.class));
            super.addBlockField("generic declaration", this.wrapElementAs(type, GenericDeclaration.class));
            super.addBlockField("annotated element", this.wrapElementAs(type, AnnotatedElement.class));
            super.addField("accessible", type.isAccessible());
            super.addField("return type", type.getReturnType());
            super.addField("generic return type", type.getGenericReturnType());
            super.addMultiField("parameter types", type.getParameterTypes());
            super.addMultiField("generic parameter types", type.getGenericParameterTypes());
            Annotation[][] parameterAnnotations = type.getParameterAnnotations();
            ArrayList<String> annots = new ArrayList<String>();
            for (Object[] objectArray : parameterAnnotations) {
                annots.add(Arrays.toString(objectArray));
            }
            super.addMultiField("parameter annotations", annots);
            super.addField("bridge", type.isBridge());
            super.addField("var args", type.isVarArgs());
            super.addMultiField("exception types", type.getExceptionTypes());
            super.addMultiField("generic exception types", type.getGenericExceptionTypes());
        }
    }

    private static class FieldPrinter
    extends AbstractPrinter<Field> {
        private FieldPrinter() {
        }

        @Override
        protected void processType(Field type) {
            super.addTitle("Field");
            super.addBlockField("member", this.wrapElementAs(type, Member.class));
            super.addBlockField("annotated element", this.wrapElementAs(type, AnnotatedElement.class));
            super.addField("accessible", type.isAccessible());
            super.addField("type", type.getType());
            super.addField("generic type", type.getGenericType());
            super.addField("enum constant", type.isEnumConstant());
        }
    }

    private static final class AnnotationPrinter
    extends AbstractPrinter<Annotation> {
        private AnnotationPrinter() {
        }

        @Override
        protected void processType(Annotation type) {
            super.addTitle("Annotation");
            super.addField("annotationType", type.annotationType());
        }
    }

    private static class GenericDeclarationPrinter
    extends AbstractPrinter<GenericDeclaration> {
        private GenericDeclarationPrinter() {
        }

        @Override
        protected void processType(GenericDeclaration type) {
            super.addTitle("GenericDeclaration");
            super.addMultiField("typeParameters", this.wrapElementArray(type.getTypeParameters()));
        }
    }

    private static class MemberPrinter
    extends AbstractPrinter<Member> {
        private MemberPrinter() {
        }

        @Override
        protected void processType(Member type) {
            super.addTitle("Member");
            super.addField("name", type.getName());
            super.addField("declaringClass", type.getDeclaringClass());
            super.addField("modifiers", Modifier.toString(type.getModifiers()));
            super.addField("synthetic", type.isSynthetic());
        }
    }

    public static class AnnotatedElementPrinter
    extends AbstractPrinter<AnnotatedElement> {
        @Override
        protected void processType(AnnotatedElement type) {
            String suffix = "";
            String prefix = "";
            if (this.excludePublicElementsFromDeclared()) {
                suffix = " (excluding public)";
                prefix = "public ";
            }
            Object[] annotations = type.getAnnotations();
            super.addTitle("AnnotatedElement");
            super.addMultiField(prefix + "annotations", this.wrapElementArray(annotations));
            super.addMultiField("declared annotations" + suffix, this.wrapElements(this.publicElementFilter(annotations, type.getDeclaredAnnotations())));
        }

        private <T> List<T> publicElementFilter(T[] publicElements, T[] declaredElements) {
            ArrayList<T> nonPublicClasses = new ArrayList<T>(Arrays.asList(declaredElements));
            if (this.excludePublicElementsFromDeclared()) {
                nonPublicClasses.removeAll(Arrays.asList(publicElements));
            }
            return nonPublicClasses;
        }
    }

    private static class TypeVariablePrinter
    extends AbstractPrinter<TypeVariable<?>> {
        private TypeVariablePrinter() {
        }

        @Override
        protected void processType(TypeVariable<?> type) {
            super.addTitle("TypeVariable");
            super.addField("generic declaration", type.getGenericDeclaration());
            super.addField("name", type.getName());
            super.addMultiField("bounds", this.wrapElementArray(type.getBounds()));
        }
    }

    private static class ParameterizedTypePrinter
    extends AbstractPrinter<ParameterizedType> {
        private ParameterizedTypePrinter() {
        }

        @Override
        protected void processType(ParameterizedType type) {
            super.addTitle("ParameterizedType");
            super.addField("owner type", type.getOwnerType());
            super.addField("raw type", type.getRawType());
            super.addMultiField("actual type parameters", this.wrapElementArray(type.getActualTypeArguments()));
        }
    }

    private static class GenericArrayTypePrinter
    extends AbstractPrinter<GenericArrayType> {
        private GenericArrayTypePrinter() {
        }

        @Override
        protected void processType(GenericArrayType type) {
            super.addTitle("GenericArrayType");
            super.addBlockField("generic component type", this.wrapElement(type.getGenericComponentType()));
        }
    }

    private static class WildcardTypePrinter
    extends AbstractPrinter<WildcardType> {
        private WildcardTypePrinter() {
        }

        @Override
        protected void processType(WildcardType type) {
            super.addTitle("WildcardType");
            super.addMultiField("lower bounds", this.wrapElementArray(type.getLowerBounds()));
            super.addMultiField("upper bounds", this.wrapElementArray(type.getUpperBounds()));
        }
    }

    private static class DefaultTypePrinter
    extends AbstractPrinter<Type> {
        private DefaultTypePrinter() {
        }

        @Override
        protected void processType(Type type) {
            super.addTitle("Type");
            super.addField("class", type.toString());
        }
    }

    public static abstract class AbstractPrinter<T>
    implements IPrinter<T> {
        private static final String FIELD_SEPARATOR = ", ";
        private static final String BLOCK_OPENING = "[";
        private static final String BLOCK_CLOSING = "]";
        private static final String COMPOSITE_OPENING = "{";
        private static final String COMPOSITE_CLOSING = "}";
        private static final String INDEXATION = "\t";
        private static final String NEW_LINE = System.getProperty("line.separator");
        private List<Entry> fields = new ArrayList<Entry>();
        private String title = "Type";
        private boolean excludePublicElementsFromDeclared = false;
        private static final Class<?>[][] ELEMENT_WRAPPER_MAP = new Class[][]{{Constructor.class, ConstructorWrapper.class}, {Annotation.class, AnnotationWrapper.class}, {Method.class, MethodWrapper.class}, {Field.class, FieldWrapper.class}, {Type.class, TypeWrapper.class}, {Member.class, MemberWrapper.class}, {AnnotatedElement.class, AnnotatedElementWrapper.class}, {GenericDeclaration.class, GenericDeclarationWrapper.class}};

        public AbstractPrinter<T> excludePublicElementsFromDeclared(boolean excludePublicElementsFromDeclared) {
            this.excludePublicElementsFromDeclared = excludePublicElementsFromDeclared;
            return this;
        }

        public boolean excludePublicElementsFromDeclared() {
            return this.excludePublicElementsFromDeclared;
        }

        @Override
        public final String toString(T type) {
            String result = null;
            if (type != null) {
                this.processType(type);
                StringBuilder builder = new StringBuilder();
                if (!this.fields.isEmpty()) {
                    builder.append(this.title).append(" ").append(BLOCK_OPENING);
                    boolean first = true;
                    for (Entry entry : this.fields) {
                        if (!first) {
                            builder.append(FIELD_SEPARATOR);
                        } else {
                            first = false;
                        }
                        builder.append(NEW_LINE).append(INDEXATION).append(entry.field).append("=").append(entry.value);
                    }
                    builder.append(NEW_LINE).append(BLOCK_CLOSING);
                }
                result = builder.toString();
            }
            return result;
        }

        private <E> Constructor<Wrapper<E>> getWrapperConstructor(Class<E> clazz) {
            for (Class<?>[] mapping : ELEMENT_WRAPPER_MAP) {
                if (!mapping[0].equals(clazz)) continue;
                return this.getConstructor(mapping[1], mapping[0]);
            }
            for (Class<?>[] mapping : ELEMENT_WRAPPER_MAP) {
                if (!mapping[0].isAssignableFrom(clazz)) continue;
                return this.getConstructor(mapping[1], mapping[0]);
            }
            throw new IllegalArgumentException("Don't know how to wrap element of type '" + clazz.getName() + "'");
        }

        private <E> Constructor<Wrapper<E>> getConstructor(Class<?> wrapperClass, Class<?> sourceClass) {
            try {
                Constructor<Wrapper<E>> result = wrapperClass.getConstructor(sourceClass);
                return result;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
        }

        private <S> IPrinter<S> getPrinter(S value) {
            AbstractPrinter result = null;
            if (Annotation.class.isInstance(value)) {
                result = new AnnotationPrinter();
            } else if (Constructor.class.isInstance(value)) {
                result = new ConstructorPrinter();
            } else if (Method.class.isInstance(value)) {
                result = new MethodPrinter();
            } else if (Field.class.isInstance(value)) {
                result = new FieldPrinter();
            }
            return result;
        }

        private String toRawString(Object value) {
            String valueString = null;
            IPrinter<Object> printer = this.getPrinter(value);
            valueString = printer == null ? value.toString() : printer.toString(value);
            return valueString;
        }

        protected final AbstractPrinter<T> addTitle(String title) {
            this.title = title;
            return this;
        }

        protected final AbstractPrinter<T> addField(String field, Object value) {
            if (value == null) {
                return this;
            }
            String valueString = value.toString();
            if (valueString.isEmpty()) {
                return this;
            }
            this.fields.add(new Entry().withField(field).withValue(value));
            return this;
        }

        protected final AbstractPrinter<T> addBlockField(String field, Object value) {
            if (value == null) {
                return this;
            }
            String valueString = this.toRawString(value);
            if (valueString.isEmpty()) {
                return this;
            }
            this.fields.add(new Entry().withField(field).withValue(COMPOSITE_OPENING + NEW_LINE + INDEXATION + INDEXATION + valueString.replace(NEW_LINE, NEW_LINE + INDEXATION + INDEXATION) + NEW_LINE + INDEXATION + COMPOSITE_CLOSING));
            return this;
        }

        protected final AbstractPrinter<T> addMultiField(String field, Object[] values) {
            if (values == null || values.length == 0) {
                return this;
            }
            return this.addMultiField(field, Arrays.asList(values));
        }

        protected final AbstractPrinter<T> addMultiField(String field, Collection<?> values) {
            if (values == null || values.isEmpty()) {
                return this;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(COMPOSITE_OPENING);
            boolean first = true;
            boolean nonEmpty = false;
            for (Object value : values) {
                String valueString;
                if (value == null || (valueString = this.toRawString(value)).isEmpty()) continue;
                if (!first) {
                    builder.append(FIELD_SEPARATOR);
                } else {
                    first = false;
                }
                builder.append(NEW_LINE).append(INDEXATION).append(valueString.replace(NEW_LINE, NEW_LINE + INDEXATION));
                nonEmpty = true;
            }
            builder.append(NEW_LINE).append(COMPOSITE_CLOSING);
            if (nonEmpty) {
                this.fields.add(new Entry().withField(field).withValue(builder.toString().replace(NEW_LINE, NEW_LINE + INDEXATION)));
            }
            return this;
        }

        protected final <E, S extends E> Wrapper<E> wrapElement(S element) {
            if (element == null) {
                return null;
            }
            Class<?> clazz = element.getClass();
            return this.wrapElementAs(element, clazz);
        }

        protected final List<Wrapper<?>> wrapElements(List<?> elements) {
            ArrayList result = new ArrayList();
            if (elements != null) {
                for (Object element : elements) {
                    result.add(this.wrapElement(element));
                }
            }
            return result;
        }

        protected final List<Wrapper<?>> wrapElementArray(Object[] elements) {
            List<Wrapper<Object>> result = null;
            result = elements != null ? this.wrapElements(Arrays.asList(elements)) : Collections.emptyList();
            return result;
        }

        protected final <E, S extends E> Wrapper<E> wrapElementAs(S element, Class<E> clazz) {
            if (element == null) {
                return null;
            }
            try {
                Wrapper<E> result = this.getWrapperConstructor(clazz).newInstance(element);
                result.excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared());
                return result;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
        }

        protected final <E, S extends E, W extends Wrapper<E>> W wrapElementWith(S element, Class<W> wrapperClass) {
            if (element == null) {
                return null;
            }
            try {
                Constructor<W> result = wrapperClass.getConstructor(element.getClass());
                Wrapper newInstance = (Wrapper)result.newInstance(element);
                newInstance.excludePublicElementsFromDeclared(this.excludePublicElementsFromDeclared);
                return (W)newInstance;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
        }

        protected final <E, S extends E, W extends Wrapper<E>> W wrapElementAsWith(S element, Class<E> clazz, Class<W> wrapperClass) {
            if (element == null) {
                return null;
            }
            try {
                Constructor<W> result = wrapperClass.getConstructor(clazz);
                return (W)((Wrapper)result.newInstance(element));
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Could not retrieve constructor for wrapper class", e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not instantiate wrapper ", e);
            }
        }

        protected abstract void processType(T var1);

        private static class Entry {
            private String field;
            private Object value;

            private Entry() {
            }

            public Entry withField(String field) {
                this.field = field;
                return this;
            }

            public Entry withValue(Object value) {
                this.value = value;
                return this;
            }
        }
    }

    private static interface IPrinter<E> {
        public String toString(E var1);
    }
}

