/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ldp4j.rdf.bean.Constraints;
import org.ldp4j.rdf.bean.annotations.AtLeast;
import org.ldp4j.rdf.bean.annotations.AtMost;
import org.ldp4j.rdf.bean.annotations.Optional;
import org.ldp4j.rdf.bean.annotations.Range;
import org.ldp4j.rdf.bean.annotations.Unbound;

public class ConstraintsTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testSingleConstraintValidation$AtMost() throws Exception {
        this.validateHarnessTestCases(Harness.AtMostUsage.class);
    }

    @Test
    public void testSingleConstraintValidation$AtLeast() throws Exception {
        this.validateHarnessTestCases(Harness.AtLeastUsage.class);
    }

    @Test
    public void testSingleConstraintValidation$Range() throws Exception {
        this.validateHarnessTestCases(Harness.RangeUsage.class);
    }

    @Test
    public void testSingleConstraintValidation$Optional() throws Exception {
        this.validateHarnessTestCases(Harness.OptionalUsage.class);
    }

    @Test
    public void testSingleConstraintValidation$Unbound() throws Exception {
        this.validateHarnessTestCases(Harness.UnboundUsage.class);
    }

    @Test
    public void testCompositeConstraintValidation() throws Exception {
        this.validateHarnessTestCases(Harness.Composite.class);
    }

    private void validateHarnessTestCases(Class<?> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getName().equals("$jacocoInit")) continue;
            String testCase = clazz.getCanonicalName() + "::" + m.getName();
            Context c = new Context(m);
            try {
                List constraints = Constraints.getCardinalityConstraints((Constraints.ConstraintDefinitionContext)c);
                if (!m.getName().startsWith("valid")) {
                    Assert.fail((String)("Test case " + testCase + " should fail"));
                }
                System.err.println(testCase + ": " + constraints);
            }
            catch (Exception e) {
                if (!m.getName().startsWith("invalid")) {
                    Assert.fail((String)("Test case " + testCase + " should not fail: " + e.getMessage()));
                    continue;
                }
                System.err.println(testCase + ": " + e.getMessage());
            }
        }
    }

    private static final class Context
    implements Constraints.ConstraintDefinitionContext<Method> {
        private final Class<?> type;
        private final Method member;

        private Context(Method method) {
            this.member = method;
            this.type = method.getReturnType();
        }

        public Class<?> getPropertyType() {
            return this.type;
        }

        public Method getAnnotatedMember() {
            return this.member;
        }
    }

    static final class Harness {
        Harness() {
        }

        static final class Composite {
            Composite() {
            }

            @AtMost(max=3)
            @AtLeast(min=3)
            @Unbound
            @Range(min=1, max=3)
            List<String> valid$list() {
                return null;
            }

            @AtMost(max=3)
            @AtLeast(min=3)
            @Unbound
            @Range(min=1, max=3)
            Set<String> valid$set() {
                return null;
            }

            @AtMost(max=3)
            @AtLeast(min=3)
            @Unbound
            @Range(min=1, max=3)
            String invalid$simple$object() {
                return null;
            }

            @AtMost(max=3)
            @AtLeast(min=3)
            @Unbound
            @Range(min=1, max=3)
            int invalid$simple$primitive() {
                return 0;
            }
        }

        static final class UnboundUsage {
            UnboundUsage() {
            }

            @Unbound
            List<String> valid$list() {
                return null;
            }

            @Unbound
            Set<String> valid$set() {
                return null;
            }

            @Unbound
            int invalid$type$primitive() {
                return 0;
            }

            @Unbound
            Object invalid$type$object() {
                return 0;
            }
        }

        static final class OptionalUsage {
            OptionalUsage() {
            }

            @Optional
            List<String> valid$list() {
                return null;
            }

            @Optional
            Set<String> valid$set() {
                return null;
            }

            @Optional
            int valid$simple$primitive() {
                return 0;
            }

            @Optional
            Object valid$simple$object() {
                return 0;
            }
        }

        static final class RangeUsage {
            RangeUsage() {
            }

            @Range(min=1, max=3)
            List<String> valid$list() {
                return null;
            }

            @Range(min=1, max=3)
            Set<String> valid$set() {
                return null;
            }

            @Range(min=1, max=3)
            int invalid$type$primitive() {
                return 0;
            }

            @Range(min=1, max=3)
            Object invalid$type$object() {
                return 0;
            }

            @Range(min=-1, max=3)
            Set<String> invalid$minLowerThanZero() {
                return null;
            }

            @Range(min=0, max=0)
            Set<String> invalid$maxLowerThanOne() {
                return null;
            }

            @Range(min=3, max=1)
            Set<String> invalid$maxLowerThanMin() {
                return null;
            }

            @Range(min=-1, max=-2)
            Set<String> invalid$all() {
                return null;
            }
        }

        static final class AtLeastUsage {
            AtLeastUsage() {
            }

            @AtLeast(min=3)
            List<String> valid$list() {
                return null;
            }

            @AtLeast(min=3)
            Set<String> valid$set() {
                return null;
            }

            @AtLeast(min=3)
            int invalid$type$primitive() {
                return 0;
            }

            @AtLeast(min=3)
            Object invalid$type$object() {
                return 0;
            }

            @AtLeast(min=0)
            Set<String> invalid$max() {
                return null;
            }
        }

        static final class AtMostUsage {
            AtMostUsage() {
            }

            @AtMost(max=3)
            List<String> valid$list() {
                return null;
            }

            @AtMost(max=3)
            Set<String> valid$set() {
                return null;
            }

            @AtMost(max=3)
            int invalid$type$primitive() {
                return 0;
            }

            @AtMost(max=3)
            Object invalid$type$object() {
                return 0;
            }

            @AtMost(max=1)
            Set<String> invalid$max() {
                return null;
            }
        }
    }
}

