package org.krproject.ocean.vitamins.param.service.inner.provided;

import javax.annotation.Resource;

import org.krproject.ocean.vitamins.param.constants.ParamConstants;
import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamPubsubService;
import org.krproject.ocean.vitamins.param.service.inner.model.ParamPubsubModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.MessageChannel;

import lombok.extern.slf4j.Slf4j;

/**
 * 参数广播订阅服务-AMQP媒介实现.
 * @author zhongyang
 *
 */
@Slf4j
public class ParamPubsubServiceAmqpImpl implements ParamPubsubService {

	@Autowired
	private ParamAccessService paramAccessService;
	
	@Lazy
	@Resource(name = ParamConstants.PARAM_PUBSUB_CHANNEL_NAME)
	private MessageChannel paramPubsubChannel;
		
	// 发布参数变更通知
	@Override
	public void publish(ParamPubsubModel paramPubSubModel) {
		log.info("Publish ParamPubsubModel:{}", paramPubSubModel);
		
		// 发布参数变更通知
		this.paramPubsubChannel.send(MessageBuilder.withPayload(paramPubSubModel).build());
	}

	@Override
	public void subscribe(ParamPubsubModel paramPubsubModel) {
		log.info("Subscribe ParamPubsubModel:{}", paramPubsubModel);
		
		// 缓存需要失效
		this.paramAccessService.onChangedParameter(paramPubsubModel.getOrgId(), paramPubsubModel.getParamClass(), paramPubsubModel.getParamKey());
	}

}
