package org.krproject.ocean.vitamins.param.service.inner.model;

import java.io.Serializable;

import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 参数广播订阅模型.
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
public class ParamPubsubModel implements Serializable {

	/**
	 * 机构号.
	 */
	private String orgId;

	/**
	 * 参数类名.
	 */
	private String paramClass;

	/**
	 * 参数键值.
	 */
	private String paramKey;
	
	/**
	 * 参数操作类型.
	 */
	private ParamOperationEnum paramOperation;

}
