package org.krproject.ocean.vitamins.param.service.inner;

import java.util.List;

import org.krproject.ocean.vitamins.param.service.inner.model.ParamModel;

/**
 * 参数存储服务接口.
 * @author zhongyang
 *
 */
public interface ParamStoreService {

	/**
	 * 获取参数存储模型总数.
	 * @param orgId 机构号
	 * @param paramClass 参数类名
	 * @return 参数实体总数
	 */
	Integer countParamStore(String orgId, String paramClass);
	
	/**
	 * 获取参数存储模型列表.
	 * @param orgId 机构号
	 * @param paramClass 参数类名
	 * @return List 参数实体集合
	 */
	List<ParamModel> listParamStore(String orgId, String paramClass);

	/**
	 * 获取参数存储模型.
	 * @param orgId 机构号
	 * @param paramClass 参数类名
	 * @param paramKey 参数主键
	 * @return 参数实体
	 */
	ParamModel getParamStore(String orgId, String paramClass, String paramKey);
	
	/**
	 * 添加参数存储模型.
	 * @param paramModel 参数实体
	 */
	void addParamStore(ParamModel paramModel);
	
	/**
	 * 更新参数存储模型.
	 * @param paramModel 参数实体
	 */
	void updateParamStore(ParamModel paramModel);
	
	/**
	 * 删除参数存储模型.
	 * @param orgId 机构号
	 * @param paramClass 参数类名
	 * @param paramKey 参数主键
	 * @param mtnUser 操作用户
	 */
	void removeParamStore(String orgId, String paramClass, String paramKey, String mtnUser);
		
}
