package org.krproject.ocean.vitamins.param.service;

import java.util.Map;


/**
 * 参数基础服务接口.
 * 
 * @author zhongyang
 *
 */
public interface ParamService {

	/**
	 * 获取类型参数.
	 * @param orgId 机构号
	 * @param paramClass class
	 * @return Map
	 * @param <T> 参数泛型
	 */
	<T> Map<String, T> getParameterMap(String orgId, Class<T> paramClass);
	
	/**
	 * 获取类型参数,机构号默认为'*'.
	 * @param paramClass class
	 * @return Map
	 * @param <T> 参数泛型
	 */
	<T> Map<String, T> getParameterMap(Class<T> paramClass);

	/**
	 * 获取参数.
	 * @param orgId 机构号
	 * @param paramClass class
	 * @param <T> 参数泛型
	 * @param key 主键key
	 * @return T 参数
	 */
	<T> T getParameter(String orgId, Class<T> paramClass, String key);
	
	/**
	 * 获取参数，机构号默认为'*'.
	 * @param paramClass class
	 * @param <T> 参数泛型
	 * @param key 主键key
	 * @return T 参数
	 */
	<T> T getParameter(Class<T> paramClass, String key);

	/**
	 * 增加参数.
	 * @param orgId 机构号
	 * @param key 主键key
	 * @param newParameter 参数实体
	 * @param mtnUser 用户
	 * @param <T> 参数泛型
	 */
	<T> void addParameter(String orgId, String key, T newParameter, String mtnUser);

	/**
	 * 增加参数，管理用户默认为'SYSTEM'.
	 * @param orgId 机构号
	 * @param key 主键key
	 * @param newParameter 参数实体
	 * @param <T> 参数泛型
	 */
	<T> void addParameter(String orgId, String key, T newParameter);

	/**
	 * 增加参数，机构号默认为'*'，管理用户默认为'SYSTEM'.
	 * @param key 主键key
	 * @param newParameter 参数实体
	 * @param <T> 参数泛型
	 */
	<T> void addParameter(String key, T newParameter);
	
	/**
	 * 更新参数.
	 * @param orgId 机构号
	 * @param key 主键key
	 * @param parameter 参数实体
	 * @param mtnUser 用户
	 * @param <T> 参数泛型
	 */
	<T> void updateParameter(String orgId, String key, T parameter, String mtnUser);

	/**
	 * 更新参数，管理用户默认为'SYSTEM'.
	 * @param orgId 机构号
	 * @param key 主键key
	 * @param parameter 参数实体
	 * @param <T> 参数泛型
	 */
	<T> void updateParameter(String orgId, String key, T parameter);

	/**
	 * 更新参数，机构号默认为'*'，管理用户默认为'SYSTEM'.
	 * @param key 主键key
	 * @param parameter 参数实体
	 * @param <T> 参数泛型
	 */
	<T> void updateParameter(String key, T parameter);
	
	/**
	 * 删除参数.
	 * @param orgId 机构号
	 * @param paramClass class
	 * @param key 主键key
	 * @param mtnUser 用户
	 * @param <T> 参数泛型
	 */
	<T> void removeParameter(String orgId, Class<T> paramClass, String key, String mtnUser);

	/**
	 * 删除参数，管理用户默认为'SYSTEM'.
	 * @param orgId 机构号
	 * @param paramClass class
	 * @param key 主键key
	 * @param <T> 参数泛型
	 */
	<T> void removeParameter(String orgId, Class<T> paramClass, String key);

	/**
	 * 删除参数，机构号默认为'*'，管理用户默认为'SYSTEM'.
	 * @param paramClass class
	 * @param key 主键key
	 * @param <T> 参数泛型
	 */
	<T> void removeParameter(Class<T> paramClass, String key);
		
}
