package org.krproject.ocean.vitamins.param.exception;

/**
 * 参数服务异常.
 * @author zhongyang
 *
 */
@SuppressWarnings("serial")
public class ParamException extends RuntimeException {
	
	private final ErrorCode errorCode;
	
	public ParamException(ErrorCode errorCode, String errorDesc) {
		super(errorDesc);
		this.errorCode = errorCode;
	}
	
	public ParamException(ErrorCode errorCode) {
		this.errorCode = errorCode;
	}

	public ParamException(Throwable cause) {
		super(cause);
		this.errorCode = null;
	}

	public ErrorCode getErrorCode() {
		return this.errorCode;
	}
	

}
