package org.krproject.ocean.vitamins.param.domain;

import java.io.Serializable;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;


/**
 * ParamObject(参数表)操作接口.
 * @author zhongyang
 *
 */
public interface ParamObjectRepository extends JpaRepository<ParamObjectEntity, Serializable> {
	
	Integer countByOrgIdAndParamClass(String orgId, String paramClass);
	
	List<ParamObjectEntity> findByOrgIdAndParamClass(String orgId, String paramClass);
	
	ParamObjectEntity findByOrgIdAndParamClassAndParamKey(String orgId, String paramClass, String paramKey);

}
