package org.krproject.ocean.vitamins.param.document;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 参数字段文档注解.
 * 
 * @author Tiger
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ParamField {

	/**
	 * 字段名称.
	 * @return 字段名称
	 */
	String name();
	
	/**
	 * 字段描述.
	 * @return 字段描述
	 */
	String desc() default "";

	/**
	 * 字段默认值.
	 * @return 字段默认值.
	 */
	String defaultValue() default "";

	/**
	 * 是否键值.
	 * @return 是否键值
	 */
	boolean key() default false;

}
