package org.krproject.ocean.vitamins.param.document;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 参数文档注解.
 * 
 * @author Tiger
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Param {

	/**
	 * 参数名称.
	 * @return 表名称
	 */
	String name();
	
	/**
	 * 参数描述.
	 * @return 表描述
	 */
	String desc() default "";
}
