package org.krproject.ocean.vitamins.param.config;

import org.krproject.ocean.vitamins.param.config.enums.AccessType;
import org.krproject.ocean.vitamins.param.config.enums.PubsubMedia;
import org.krproject.ocean.vitamins.param.config.enums.StoreMedia;
import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;


/**
 * 参数属性配置对象.
 * @author zhongyang
 *
 */
@Data
@ConfigurationProperties(prefix = "krproject.ocean.param")
public class ParamProperties {
	
	/**
	 * 参数访问方式.
	 * direct--直接访问参数,默认;
	 * cache--带有缓存访问参数.
	 */
	private AccessType accessType = AccessType.DIRECT;
	
	/**
	 * 参数存储介质.
	 * database--数据库,默认;
	 */
	private StoreMedia storeMedia = StoreMedia.DATABASE;
	
	/**
	 * 发布订阅介质.
	 * none--无发布订阅介质,默认;
	 * amqp--支持amqp协议的rabbitmq消息队列;
	 */
	private PubsubMedia pubsubMedia = PubsubMedia.NONE;
	
	/**
	 * 参数缓存检查间隔时间.
	 * second--默认60;
	 */
	private Integer cacheCheckSeconds = 60;
	
}
