package org.krproject.ocean.vitamins.param.config;

import org.krproject.ocean.vitamins.param.config.enums.AccessType;
import org.krproject.ocean.vitamins.param.config.enums.PubsubMedia;
import org.krproject.ocean.vitamins.param.config.enums.StoreMedia;
import org.krproject.ocean.vitamins.param.exception.ErrorCode;
import org.krproject.ocean.vitamins.param.exception.ParamException;
import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamPubsubService;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamAccessServiceCacheImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamAccessServiceDirectImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamPubsubServiceAmqpImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamPubsubServiceNoneImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamStoreServiceDatabaseImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.config.EnableIntegration;

import lombok.extern.slf4j.Slf4j;


/**
 * 参数配置文件.
 * @author zhongyang
 *
 */
@Slf4j
@Configuration
@EnableIntegration
@IntegrationComponentScan
@ComponentScan(basePackages = "org.krproject.ocean.vitamins.param")
@EntityScan({"org.krproject.ocean.vitamins.param.domain"})
@EnableJpaRepositories({"org.krproject.ocean.vitamins.param.domain"})
@EnableConfigurationProperties(ParamProperties.class)
public class ParamConfig {

	@Autowired
	private ParamProperties paramProperties;
	
	// 参数访问服务配置.
	@Bean
	public ParamAccessService paramAccessService() {
		log.info("Param Access Type: {}", this.paramProperties.getAccessType());
		if (this.paramProperties.getAccessType() == AccessType.CACHE) {
			return new ParamAccessServiceCacheImpl();
		} else if (this.paramProperties.getAccessType() == AccessType.DIRECT) {
			return new ParamAccessServiceDirectImpl();
		} else {
			throw new ParamException(ErrorCode.PARAM_SYSTEM_ERROR, "参数访问类型不支持" + this.paramProperties.getAccessType());
		}
	}
	
	// 参数通知服务配置.
	@Bean
	public ParamPubsubService paramPubsubService() {
		log.info("Param Pubsub Media: {}", this.paramProperties.getPubsubMedia());
		if (this.paramProperties.getPubsubMedia().equals(PubsubMedia.NONE)) {
			return new ParamPubsubServiceNoneImpl();
		} else if (this.paramProperties.getPubsubMedia().equals(PubsubMedia.AMQP)) {
			return new ParamPubsubServiceAmqpImpl();
		} else {
			throw new ParamException(ErrorCode.PARAM_SYSTEM_ERROR, "参数通知媒介不支持" + this.paramProperties.getPubsubMedia());
		}
	}
	
	// 参数持久服务配置.
	@Bean
	public ParamStoreService paramStoreService() {
		log.info("Param Store Media: {}", this.paramProperties.getStoreMedia());
		if (this.paramProperties.getStoreMedia().equals(StoreMedia.DATABASE)) {
			return new ParamStoreServiceDatabaseImpl();
		} else {
			throw new ParamException(ErrorCode.PARAM_SYSTEM_ERROR, "参数存储媒介不支持" + this.paramProperties.getStoreMedia());
		}
	}
	
}
