/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.param.service.inner.provided;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.krproject.ocean.vitamins.param.domain.ParamAuditEntity;
import org.krproject.ocean.vitamins.param.domain.ParamAuditRepository;
import org.krproject.ocean.vitamins.param.domain.ParamObjectEntity;
import org.krproject.ocean.vitamins.param.domain.ParamObjectRepository;
import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;
import org.krproject.ocean.vitamins.param.exception.ErrorCode;
import org.krproject.ocean.vitamins.param.exception.ParamException;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;
import org.krproject.ocean.vitamins.param.service.inner.model.ParamModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class ParamStoreServiceDatabaseImpl
implements ParamStoreService {
    private static final Logger log = LoggerFactory.getLogger(ParamStoreServiceDatabaseImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private ParamObjectRepository paramObjectRepository;
    @Autowired
    private ParamAuditRepository paramAuditRepository;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Integer countParamStore(String orgId, String paramClass) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramClass, (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        return this.paramObjectRepository.countByOrgIdAndParamClass(orgId, paramClass);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<ParamModel> listParamStore(String orgId, String paramClass) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramClass, (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        List<ParamObjectEntity> entityList = this.paramObjectRepository.findByOrgIdAndParamClass(orgId, paramClass);
        if (entityList != null && entityList.size() > 0) {
            ArrayList<ParamModel> paramModels = new ArrayList<ParamModel>();
            for (ParamObjectEntity entity : entityList) {
                paramModels.add(new ParamStoreConverter().apply(entity));
            }
            return paramModels;
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ParamModel getParamStore(String orgId, String paramClass, String paramKey) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramKey, (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramClass, (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        ParamObjectEntity entity = this.paramObjectRepository.findByOrgIdAndParamClassAndParamKey(orgId, paramClass, paramKey);
        return new ParamStoreConverter().apply(entity);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void addParamStore(ParamModel paramModel) {
        Assert.notNull((Object)paramModel, (String)"\u6307\u5b9a\u53c2\u6570\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getOrgId(), (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getParamKey(), (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getParamClass(), (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getParamObject(), (String)"\u6307\u5b9a\u53c2\u6570\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        ParamObjectEntity paramObjectChk = this.paramObjectRepository.findByOrgIdAndParamClassAndParamKey(paramModel.getOrgId(), paramModel.getParamClass(), paramModel.getParamKey());
        if (paramObjectChk != null) {
            throw new ParamException(ErrorCode.PARAM_ALREADY_EXISTS, "\u53c2\u6570:[" + paramModel.toString() + "],\u5df2\u5b58\u5728!");
        }
        ParamObjectEntity entity = new ParamObjectEntity();
        entity.setOrgId(paramModel.getOrgId());
        entity.setParamClass(paramModel.getParamClass());
        entity.setParamKey(paramModel.getParamKey());
        entity.setParamObject(this.marshalParamObject(paramModel.getParamObject()));
        entity.setMtnUser(paramModel.getMtnUser());
        entity.setLastUpdateTime(paramModel.getLastUpdateTime());
        entity.setCreateTime(new Date());
        this.paramObjectRepository.saveAndFlush(entity);
        ParamAuditEntity paramAuditEntity = new ParamAuditEntity();
        paramAuditEntity.setOrgId(entity.getOrgId());
        paramAuditEntity.setParamClass(entity.getParamClass());
        paramAuditEntity.setParamKey(entity.getParamKey());
        paramAuditEntity.setParamOperation(ParamOperationEnum.INSERT);
        paramAuditEntity.setMtnUser(entity.getMtnUser());
        paramAuditEntity.setMtnMemo("\u65b0\u589e\u53c2\u6570");
        paramAuditEntity.setOldObject(null);
        paramAuditEntity.setNewObject(entity.getParamObject());
        paramAuditEntity.setCreateTime(new Date());
        this.paramAuditRepository.saveAndFlush(paramAuditEntity);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateParamStore(ParamModel paramModel) {
        Assert.notNull((Object)paramModel, (String)"\u6307\u5b9a\u53c2\u6570\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getOrgId(), (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getParamKey(), (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getParamClass(), (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramModel.getParamObject(), (String)"\u6307\u5b9a\u53c2\u6570\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        ParamObjectEntity entity = this.paramObjectRepository.findByOrgIdAndParamClassAndParamKey(paramModel.getOrgId(), paramModel.getParamClass(), paramModel.getParamKey());
        if (entity == null) {
            throw new ParamException(ErrorCode.PARAM_NOT_FOUND, "\u53c2\u6570:[" + paramModel.toString() + "],\u672a\u627e\u5230!");
        }
        String oldParamObject = entity.getParamObject();
        String newParamObject = this.marshalParamObject(paramModel.getParamObject());
        entity.setParamObject(newParamObject);
        entity.setMtnUser(paramModel.getMtnUser());
        entity.setLastUpdateTime(paramModel.getLastUpdateTime());
        this.paramObjectRepository.saveAndFlush(entity);
        ParamAuditEntity paramAuditEntity = new ParamAuditEntity();
        paramAuditEntity.setOrgId(entity.getOrgId());
        paramAuditEntity.setParamClass(entity.getParamClass());
        paramAuditEntity.setParamKey(entity.getParamKey());
        paramAuditEntity.setParamOperation(ParamOperationEnum.UPDATE);
        paramAuditEntity.setMtnUser(entity.getMtnUser());
        paramAuditEntity.setMtnMemo("\u66f4\u65b0\u53c2\u6570");
        paramAuditEntity.setOldObject(oldParamObject);
        paramAuditEntity.setNewObject(newParamObject);
        paramAuditEntity.setCreateTime(new Date());
        this.paramAuditRepository.saveAndFlush(paramAuditEntity);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void removeParamStore(String orgId, String paramClass, String paramKey, String mtnUser) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramKey, (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramClass, (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        ParamObjectEntity entity = this.paramObjectRepository.findByOrgIdAndParamClassAndParamKey(orgId, paramClass, paramKey);
        if (entity == null) {
            throw new ParamException(ErrorCode.PARAM_NOT_FOUND, "\u673a\u6784\u53f7:[" + orgId + "],ParamClass:[" + paramClass + "],ParamKey:[" + paramKey + "],\u53c2\u6570\u672a\u627e\u5230\uff01");
        }
        this.paramObjectRepository.delete(entity);
        ParamAuditEntity paramAuditEntity = new ParamAuditEntity();
        paramAuditEntity.setOrgId(entity.getOrgId());
        paramAuditEntity.setParamClass(entity.getParamClass());
        paramAuditEntity.setParamKey(entity.getParamKey());
        paramAuditEntity.setParamOperation(ParamOperationEnum.DELETE);
        paramAuditEntity.setMtnUser(entity.getMtnUser());
        paramAuditEntity.setMtnMemo("\u5220\u9664\u53c2\u6570");
        paramAuditEntity.setOldObject(entity.getParamObject());
        paramAuditEntity.setNewObject(null);
        paramAuditEntity.setCreateTime(new Date());
        this.paramAuditRepository.saveAndFlush(paramAuditEntity);
    }

    private String marshalParamObject(Object paramObject) {
        String str = null;
        try {
            str = objectMapper.writeValueAsString(paramObject);
        }
        catch (Exception e) {
            log.error("marshal object:{} failed with exception:{}", paramObject, (Object)e);
            throw new ParamException(ErrorCode.PARAM_PARSE_ERROR, "marshal paramObject failed!");
        }
        return str;
    }

    private Object unmarshalParamObject(String paramObjectStr, String paramObjectClz) {
        Object obj = null;
        try {
            Class<?> clazz = Class.forName(paramObjectClz);
            obj = objectMapper.readValue(paramObjectStr, clazz);
        }
        catch (Exception e) {
            log.error("unmarshal message:{} class:{} failed with exception:{}", new Object[]{paramObjectStr, paramObjectClz, e});
            throw new ParamException(ErrorCode.PARAM_PARSE_ERROR, "unmarshal paramObject failed!");
        }
        return obj;
    }

    static {
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private class ParamStoreConverter
    implements Function<ParamObjectEntity, ParamModel> {
        private ParamStoreConverter() {
        }

        @Override
        public ParamModel apply(ParamObjectEntity entity) {
            if (entity != null) {
                ParamModel model = new ParamModel();
                model.setOrgId(entity.getOrgId());
                model.setParamClass(entity.getParamClass());
                model.setParamKey(entity.getParamKey());
                model.setParamObject(ParamStoreServiceDatabaseImpl.this.unmarshalParamObject(entity.getParamObject(), entity.getParamClass()));
                model.setMtnUser(entity.getMtnUser());
                model.setLastUpdateTime(entity.getLastUpdateTime());
                return model;
            }
            return null;
        }
    }
}

