/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.param.service.inner.provided;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;
import org.krproject.ocean.vitamins.param.service.inner.model.ParamModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamAccessServiceDirectImpl
implements ParamAccessService {
    private static final Logger log = LoggerFactory.getLogger(ParamAccessServiceDirectImpl.class);

    @Override
    public <T> T getParameter(String orgId, String paramClass, String key, ParamStoreService paramStoreService) {
        log.debug("getParameter with orgId:{}, paramClass:{}, key:{}", new Object[]{orgId, paramClass, key});
        ParamModel paramStoreModel = paramStoreService.getParamStore(orgId, paramClass, key);
        if (paramStoreModel != null) {
            return (T)paramStoreModel.getParamObject();
        }
        return null;
    }

    @Override
    public <T> Map<String, T> getParameterMap(String orgId, String paramClass, ParamStoreService paramStoreService) {
        log.debug("getParameterMap with orgId:{}, paramClass:{}", (Object)orgId, (Object)paramClass);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        List<ParamModel> listParamModel = paramStoreService.listParamStore(orgId, paramClass);
        if (listParamModel != null && listParamModel.size() > 0) {
            for (ParamModel paramStoreModel : listParamModel) {
                paramMap.put(paramStoreModel.getParamKey(), paramStoreModel.getParamObject());
            }
        }
        return paramMap;
    }

    @Override
    public void onChangedParameter(String orgId, String paramClass, String key) {
        log.debug("onChangedParameter with orgId:{}, paramClass:{}, key:{}", new Object[]{orgId, paramClass, key});
    }
}

