/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.param.service.inner.provided;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.krproject.ocean.vitamins.param.config.ParamProperties;
import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;
import org.krproject.ocean.vitamins.param.service.inner.model.ParamModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class ParamAccessServiceCacheImpl
implements ParamAccessService,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ParamAccessServiceCacheImpl.class);
    private final ConcurrentHashMap<String, ParamModelWrapper> paramCacheMap = new ConcurrentHashMap();
    @Autowired
    private ParamProperties paramProperties;
    private AtomicBoolean running = new AtomicBoolean(false);
    private ThreadPoolTaskScheduler paramCacheCheckTaskScheduler;
    private ScheduledFuture<?> watchFuture;

    @PostConstruct
    public void init() {
        this.paramCacheCheckTaskScheduler = new ThreadPoolTaskScheduler();
        this.paramCacheCheckTaskScheduler.setBeanName("paramCacheCheckTaskScheduler");
        this.paramCacheCheckTaskScheduler.setThreadNamePrefix("param-cache-check-");
        this.paramCacheCheckTaskScheduler.initialize();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.paramCacheCheckTaskScheduler.scheduleWithFixedDelay(this::checkParamCache, (long)(this.paramProperties.getCacheCheckSeconds() * 1000));
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    private void checkParamCache() {
        if (this.running.get()) {
            log.debug("checking param cache:{}", this.paramCacheMap);
            for (Map.Entry<String, ParamModelWrapper> entry : this.paramCacheMap.entrySet()) {
                int paramStoreSize;
                int paramCacheSize;
                ParamModelWrapper paramModelWrapper = entry.getValue();
                ParamStoreService paramStoreService = paramModelWrapper.getParamStoreService();
                if (paramModelWrapper.getContainAll().booleanValue() && (paramCacheSize = paramModelWrapper.getParamModelMap().size()) != (paramStoreSize = paramStoreService.countParamStore(paramModelWrapper.getOrgId(), paramModelWrapper.getParamClass()).intValue())) {
                    log.warn("Check Param Cache Size Diff, paramType:{}, paramCacheSize:{} paramStoreSize:{}", new Object[]{entry.getKey(), paramCacheSize, paramStoreSize});
                    paramModelWrapper.getParamModelMap().clear();
                    paramModelWrapper.setContainAll(false);
                }
                for (Map.Entry<String, ParamModel> cacheEntry : paramModelWrapper.getParamModelMap().entrySet()) {
                    ParamModel paramCacheModel = cacheEntry.getValue();
                    ParamModel paramStoreModel = paramStoreService.getParamStore(paramCacheModel.getOrgId(), paramCacheModel.getParamClass(), paramCacheModel.getParamKey());
                    if (paramStoreModel != null && paramStoreModel.getLastUpdateTime() != null && paramCacheModel.getLastUpdateTime() != null && paramStoreModel.getLastUpdateTime().compareTo(paramCacheModel.getLastUpdateTime()) == 0) continue;
                    log.warn("Check Param Cache Value Diff, paramKey:{}. paramCacheModel:{} paramStoreModel:{}", new Object[]{cacheEntry.getKey(), paramCacheModel, paramStoreModel});
                    paramModelWrapper.getParamModelMap().remove(cacheEntry.getKey());
                    paramModelWrapper.setContainAll(false);
                }
            }
        }
    }

    @Override
    public <T> T getParameter(String orgId, String paramClass, String key, ParamStoreService paramStoreService) {
        ConcurrentHashMap<String, ParamModel> paramModelMap;
        log.debug("getParameter with orgId:{}, paramClass:{}, key:{}", new Object[]{orgId, paramClass, key});
        String paramTypeKey = this.getCacheTypeKey(orgId, paramClass);
        ParamModelWrapper paramModelWrapper = this.paramCacheMap.get(paramTypeKey);
        if (paramModelWrapper == null) {
            paramModelWrapper = new ParamModelWrapper();
            paramModelWrapper.setOrgId(orgId);
            paramModelWrapper.setParamClass(paramClass);
            paramModelWrapper.setParamModelMap(new ConcurrentHashMap<String, ParamModel>());
            paramModelWrapper.setParamStoreService(paramStoreService);
            paramModelWrapper.setContainAll(false);
            this.paramCacheMap.put(paramTypeKey, paramModelWrapper);
        }
        if ((paramModelMap = paramModelWrapper.getParamModelMap()).get(key) == null) {
            log.debug("getParameter through store with orgId:{}, paramClass:{}, key:{}", new Object[]{orgId, paramClass, key});
            ParamModel paramModel = paramStoreService.getParamStore(orgId, paramClass, key);
            if (paramModel != null) {
                paramModelMap.put(paramModel.getParamKey(), paramModel);
            }
        }
        if (paramModelMap.get(key) != null) {
            return (T)paramModelMap.get(key).getParamObject();
        }
        return null;
    }

    @Override
    public <T> Map<String, T> getParameterMap(String orgId, String paramClass, ParamStoreService paramStoreService) {
        log.debug("getParameterMap with orgId:{}, paramClass:{}", (Object)orgId, (Object)paramClass);
        String paramTypeKey = this.getCacheTypeKey(orgId, paramClass);
        ParamModelWrapper paramModelWrapper = this.paramCacheMap.get(paramTypeKey);
        if (paramModelWrapper == null) {
            paramModelWrapper = new ParamModelWrapper();
            paramModelWrapper.setOrgId(orgId);
            paramModelWrapper.setParamClass(paramClass);
            paramModelWrapper.setParamModelMap(new ConcurrentHashMap<String, ParamModel>());
            paramModelWrapper.setParamStoreService(paramStoreService);
            paramModelWrapper.setContainAll(false);
            this.paramCacheMap.put(paramTypeKey, paramModelWrapper);
        }
        ConcurrentHashMap<String, ParamModel> paramModelMap = paramModelWrapper.getParamModelMap();
        if (!paramModelWrapper.getContainAll().booleanValue()) {
            log.debug("getParameterMap through store with orgId:{}, paramClass:{}", (Object)orgId, (Object)paramClass);
            List<ParamModel> paramModelList = paramStoreService.listParamStore(orgId, paramClass);
            if (paramModelList != null && paramModelList.size() > 0) {
                for (ParamModel paramModel : paramModelList) {
                    paramModelMap.put(paramModel.getParamKey(), paramModel);
                }
                paramModelWrapper.setContainAll(true);
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (ParamModel paramModel : paramModelMap.values()) {
            paramMap.put(paramModel.getParamKey(), paramModel.getParamObject());
        }
        return paramMap;
    }

    @Override
    public void onChangedParameter(String orgId, String paramClassName, String key) {
        log.debug("onChangedParameter with orgId:{}, paramClass:{}, key:{}", new Object[]{orgId, paramClassName, key});
        String paramTypeKey = this.getCacheTypeKey(orgId, paramClassName);
        ParamModelWrapper paramModelWrapper = this.paramCacheMap.get(paramTypeKey);
        if (paramModelWrapper != null) {
            if (paramModelWrapper.getContainAll().booleanValue()) {
                paramModelWrapper.getParamModelMap().clear();
            } else {
                paramModelWrapper.getParamModelMap().remove(key);
            }
            paramModelWrapper.setContainAll(false);
        }
    }

    private String getCacheTypeKey(String orgId, String paramClassName) {
        return orgId + "@!@" + paramClassName;
    }

    private class ParamModelWrapper
    implements Serializable {
        private String orgId;
        private String paramClass;
        private ConcurrentHashMap<String, ParamModel> paramModelMap;
        private ParamStoreService paramStoreService;
        private Boolean containAll;

        public String getOrgId() {
            return this.orgId;
        }

        public String getParamClass() {
            return this.paramClass;
        }

        public ConcurrentHashMap<String, ParamModel> getParamModelMap() {
            return this.paramModelMap;
        }

        public ParamStoreService getParamStoreService() {
            return this.paramStoreService;
        }

        public Boolean getContainAll() {
            return this.containAll;
        }

        public void setOrgId(String orgId) {
            this.orgId = orgId;
        }

        public void setParamClass(String paramClass) {
            this.paramClass = paramClass;
        }

        public void setParamModelMap(ConcurrentHashMap<String, ParamModel> paramModelMap) {
            this.paramModelMap = paramModelMap;
        }

        public void setParamStoreService(ParamStoreService paramStoreService) {
            this.paramStoreService = paramStoreService;
        }

        public void setContainAll(Boolean containAll) {
            this.containAll = containAll;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamModelWrapper)) {
                return false;
            }
            ParamModelWrapper other = (ParamModelWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$containAll = this.getContainAll();
            Boolean other$containAll = other.getContainAll();
            if (this$containAll == null ? other$containAll != null : !((Object)this$containAll).equals(other$containAll)) {
                return false;
            }
            String this$orgId = this.getOrgId();
            String other$orgId = other.getOrgId();
            if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
                return false;
            }
            String this$paramClass = this.getParamClass();
            String other$paramClass = other.getParamClass();
            if (this$paramClass == null ? other$paramClass != null : !this$paramClass.equals(other$paramClass)) {
                return false;
            }
            ConcurrentHashMap<String, ParamModel> this$paramModelMap = this.getParamModelMap();
            ConcurrentHashMap<String, ParamModel> other$paramModelMap = other.getParamModelMap();
            if (this$paramModelMap == null ? other$paramModelMap != null : !((Object)this$paramModelMap).equals(other$paramModelMap)) {
                return false;
            }
            ParamStoreService this$paramStoreService = this.getParamStoreService();
            ParamStoreService other$paramStoreService = other.getParamStoreService();
            return !(this$paramStoreService == null ? other$paramStoreService != null : !this$paramStoreService.equals(other$paramStoreService));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParamModelWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $containAll = this.getContainAll();
            result = result * 59 + ($containAll == null ? 43 : ((Object)$containAll).hashCode());
            String $orgId = this.getOrgId();
            result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
            String $paramClass = this.getParamClass();
            result = result * 59 + ($paramClass == null ? 43 : $paramClass.hashCode());
            ConcurrentHashMap<String, ParamModel> $paramModelMap = this.getParamModelMap();
            result = result * 59 + ($paramModelMap == null ? 43 : ((Object)$paramModelMap).hashCode());
            ParamStoreService $paramStoreService = this.getParamStoreService();
            result = result * 59 + ($paramStoreService == null ? 43 : $paramStoreService.hashCode());
            return result;
        }

        public String toString() {
            return "ParamAccessServiceCacheImpl.ParamModelWrapper(orgId=" + this.getOrgId() + ", paramClass=" + this.getParamClass() + ", paramModelMap=" + this.getParamModelMap() + ", paramStoreService=" + this.getParamStoreService() + ", containAll=" + this.getContainAll() + ")";
        }
    }
}

