/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.param.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;
import org.krproject.ocean.vitamins.param.event.ParamChangedEvent;
import org.krproject.ocean.vitamins.param.service.ParamService;
import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamPubsubService;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;
import org.krproject.ocean.vitamins.param.service.inner.customize.AbstractParamCustomize;
import org.krproject.ocean.vitamins.param.service.inner.model.ParamModel;
import org.krproject.ocean.vitamins.param.service.inner.model.ParamPubsubModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ParamServiceImpl
implements ParamService {
    private static final Logger log = LoggerFactory.getLogger(ParamServiceImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ParamAccessService paramAccessService;
    @Autowired
    private ParamPubsubService paramPubsubService;
    @Autowired
    private ParamStoreService paramStoreService;
    @Autowired(required=false)
    private List<AbstractParamCustomize<?>> paramCustomizes;
    private Map<String, AbstractParamCustomize<?>> paramCustomizeMap = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        if (this.paramCustomizes != null) {
            for (AbstractParamCustomize<?> paramCustomize : this.paramCustomizes) {
                log.info("Param Customized:{}", (Object)paramCustomize.getParamClass().getCanonicalName());
                this.paramCustomizeMap.put(paramCustomize.getParamClass().getCanonicalName(), paramCustomize);
            }
        }
    }

    @Override
    public <T> Map<String, T> getParameterMap(String orgId, Class<T> paramClass) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(paramClass, (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        String paramClassName = paramClass.getCanonicalName();
        AbstractParamCustomize<?> paramCustomize = this.paramCustomizeMap.get(paramClassName);
        if (paramCustomize != null) {
            return paramCustomize.getParameterMap(orgId, paramClassName, paramCustomize);
        }
        return this.paramAccessService.getParameterMap(orgId, paramClassName, this.paramStoreService);
    }

    @Override
    public <T> Map<String, T> getParameterMap(Class<T> paramClass) {
        return this.getParameterMap("*", paramClass);
    }

    @Override
    public <T> T getParameter(String orgId, Class<T> paramClass, String key) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(paramClass, (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)key, (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        String paramClassName = paramClass.getCanonicalName();
        AbstractParamCustomize<?> paramCustomize = this.paramCustomizeMap.get(paramClassName);
        if (paramCustomize != null) {
            return paramCustomize.getParameter(orgId, paramClassName, key, paramCustomize);
        }
        return this.paramAccessService.getParameter(orgId, paramClassName, key, this.paramStoreService);
    }

    @Override
    public <T> T getParameter(Class<T> paramClass, String key) {
        return this.getParameter("*", paramClass, key);
    }

    @Override
    public <T> void addParameter(String orgId, String key, T parameter, String mtnUser) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(parameter, (String)"\u6307\u5b9a\u53c2\u6570parameter\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)key, (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        String paramClassName = parameter.getClass().getCanonicalName();
        ParamModel paramModel = new ParamModel();
        paramModel.setOrgId(orgId);
        paramModel.setParamClass(paramClassName);
        paramModel.setParamKey(key);
        paramModel.setParamObject(parameter);
        paramModel.setMtnUser(mtnUser);
        paramModel.setLastUpdateTime(new Date());
        AbstractParamCustomize<?> paramCustomize = this.paramCustomizeMap.get(paramClassName);
        if (paramCustomize != null) {
            paramCustomize.addParamStore(paramModel);
        } else {
            this.paramStoreService.addParamStore(paramModel);
        }
        this.paramPubsubService.publish(new ParamPubsubModel(orgId, paramClassName, key, ParamOperationEnum.INSERT));
        this.applicationContext.publishEvent((ApplicationEvent)new ParamChangedEvent(this, orgId, paramClassName, key, ParamOperationEnum.INSERT));
    }

    @Override
    public <T> void addParameter(String orgId, String key, T parameter) {
        this.addParameter(orgId, key, parameter, "SYSTEM");
    }

    @Override
    public <T> void addParameter(String key, T parameter) {
        this.addParameter("*", key, parameter, "SYSTEM");
    }

    @Override
    public <T> void updateParameter(String orgId, String key, T parameter, String mtnUser) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(parameter, (String)"\u6307\u5b9a\u53c2\u6570parameter\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)key, (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        String paramClassName = parameter.getClass().getCanonicalName();
        ParamModel paramModel = new ParamModel();
        paramModel.setOrgId(orgId);
        paramModel.setParamClass(paramClassName);
        paramModel.setParamKey(key);
        paramModel.setParamObject(parameter);
        paramModel.setMtnUser(mtnUser);
        paramModel.setLastUpdateTime(new Date());
        AbstractParamCustomize<?> paramCustomize = this.paramCustomizeMap.get(paramClassName);
        if (paramCustomize != null) {
            paramCustomize.updateParamStore(paramModel);
        } else {
            this.paramStoreService.updateParamStore(paramModel);
        }
        this.paramPubsubService.publish(new ParamPubsubModel(orgId, paramClassName, key, ParamOperationEnum.UPDATE));
        this.applicationContext.publishEvent((ApplicationEvent)new ParamChangedEvent(this, orgId, paramClassName, key, ParamOperationEnum.UPDATE));
    }

    @Override
    public <T> void updateParameter(String orgId, String key, T parameter) {
        this.updateParameter(orgId, key, parameter, "SYSTEM");
    }

    @Override
    public <T> void updateParameter(String key, T parameter) {
        this.updateParameter("*", key, parameter, "SYSTEM");
    }

    @Override
    public <T> void removeParameter(String orgId, Class<T> paramClass, String key, String mtnUser) {
        Assert.notNull((Object)orgId, (String)"\u6307\u5b9a\u53c2\u6570orgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(paramClass, (String)"\u6307\u5b9a\u53c2\u6570paramClass\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)key, (String)"\u6307\u5b9a\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a");
        String paramClassName = paramClass.getCanonicalName();
        AbstractParamCustomize<?> paramCustomize = this.paramCustomizeMap.get(paramClassName);
        if (paramCustomize != null) {
            paramCustomize.removeParamStore(orgId, paramClassName, key, mtnUser);
        } else {
            this.paramStoreService.removeParamStore(orgId, paramClassName, key, mtnUser);
        }
        this.paramPubsubService.publish(new ParamPubsubModel(orgId, paramClassName, key, ParamOperationEnum.DELETE));
        this.applicationContext.publishEvent((ApplicationEvent)new ParamChangedEvent(this, orgId, paramClassName, key, ParamOperationEnum.DELETE));
    }

    @Override
    public <T> void removeParameter(String orgId, Class<T> paramClazz, String key) {
        this.removeParameter(orgId, paramClazz, key, "SYSTEM");
    }

    @Override
    public <T> void removeParameter(Class<T> paramClazz, String key) {
        this.removeParameter("*", paramClazz, key, "SYSTEM");
    }

    @ServiceActivator(inputChannel="paramPubsubChannel")
    public void subscribeEndpoint(ParamPubsubModel paramPubsubModel) {
        Assert.notNull((Object)paramPubsubModel, (String)"\u5e7f\u64ad\u8ba2\u9605\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramPubsubModel.getOrgId(), (String)"\u5e7f\u64ad\u8ba2\u9605\u6a21\u578borgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)paramPubsubModel.getParamClass(), (String)"\u5e7f\u64ad\u8ba2\u9605\u6a21\u578bparamClass\u4e0d\u80fd\u4e3a\u7a7a");
        String paramClassName = paramPubsubModel.getParamClass();
        AbstractParamCustomize<?> paramCustomize = this.paramCustomizeMap.get(paramClassName);
        if (paramCustomize != null) {
            paramCustomize.subscribe(paramPubsubModel);
        } else {
            this.paramPubsubService.subscribe(paramPubsubModel);
        }
    }
}

