/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.param.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.amqp.channel.PublishSubscribeAmqpChannel;
import org.springframework.messaging.MessageChannel;

@ConditionalOnProperty(prefix="krproject.ocean.param", name={"pubsub-media"}, havingValue="amqp", matchIfMissing=false)
@Configuration
@EnableRabbit
public class ParamPubsubAmqpConfig {
    public static final String PARAM_AMQP_EXCHANGE_NAME = "param";

    @Bean
    public FanoutExchange paramAmqpPubsubExchange() {
        return new FanoutExchange(PARAM_AMQP_EXCHANGE_NAME);
    }

    @Bean(name={"paramPubsubChannel"})
    public MessageChannel paramAmqpPubsubChannel(ConnectionFactory connectionFactory, FanoutExchange paramAmqpPubsubExchange) {
        PublishSubscribeAmqpChannel paramPubsubAmqpChannel = new PublishSubscribeAmqpChannel("paramPubsubChannel", (AbstractMessageListenerContainer)this.paramListenerContainer(connectionFactory), this.paramAmqpTemplate(connectionFactory));
        paramPubsubAmqpChannel.setExchange(paramAmqpPubsubExchange);
        paramPubsubAmqpChannel.setExtractPayload(true);
        paramPubsubAmqpChannel.afterPropertiesSet();
        return paramPubsubAmqpChannel;
    }

    private SimpleMessageListenerContainer paramListenerContainer(ConnectionFactory connectionFactory) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(connectionFactory);
        container.setDefaultRequeueRejected(false);
        container.setConcurrentConsumers(2);
        container.setPhase(0);
        return container;
    }

    private AmqpTemplate paramAmqpTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate();
        rabbitTemplate.setConnectionFactory(connectionFactory);
        rabbitTemplate.setMessageConverter(this.jsonMessageConverter());
        rabbitTemplate.setReplyTimeout(10000L);
        return rabbitTemplate;
    }

    private MessageConverter jsonMessageConverter() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        Jackson2JsonMessageConverter jackson2Converter = new Jackson2JsonMessageConverter(objectMapper);
        return jackson2Converter;
    }
}

