/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.param.config;

import org.krproject.ocean.vitamins.param.config.ParamProperties;
import org.krproject.ocean.vitamins.param.config.enums.AccessType;
import org.krproject.ocean.vitamins.param.config.enums.PubsubMedia;
import org.krproject.ocean.vitamins.param.config.enums.StoreMedia;
import org.krproject.ocean.vitamins.param.exception.ErrorCode;
import org.krproject.ocean.vitamins.param.exception.ParamException;
import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamPubsubService;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamAccessServiceCacheImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamAccessServiceDirectImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamPubsubServiceAmqpImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamPubsubServiceNoneImpl;
import org.krproject.ocean.vitamins.param.service.inner.provided.ParamStoreServiceDatabaseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.config.EnableIntegration;

@Configuration
@EnableIntegration
@IntegrationComponentScan
@ComponentScan(basePackages={"org.krproject.ocean.vitamins.param"})
@EntityScan(value={"org.krproject.ocean.vitamins.param.domain"})
@EnableJpaRepositories(value={"org.krproject.ocean.vitamins.param.domain"})
@EnableConfigurationProperties(value={ParamProperties.class})
public class ParamConfig {
    private static final Logger log = LoggerFactory.getLogger(ParamConfig.class);
    @Autowired
    private ParamProperties paramProperties;

    @Bean
    public ParamAccessService paramAccessService() {
        log.info("Param Access Type: {}", (Object)this.paramProperties.getAccessType());
        if (this.paramProperties.getAccessType() == AccessType.CACHE) {
            return new ParamAccessServiceCacheImpl();
        }
        if (this.paramProperties.getAccessType() == AccessType.DIRECT) {
            return new ParamAccessServiceDirectImpl();
        }
        throw new ParamException(ErrorCode.PARAM_SYSTEM_ERROR, "\u53c2\u6570\u8bbf\u95ee\u7c7b\u578b\u4e0d\u652f\u6301" + (Object)((Object)this.paramProperties.getAccessType()));
    }

    @Bean
    public ParamPubsubService paramPubsubService() {
        log.info("Param Pubsub Media: {}", (Object)this.paramProperties.getPubsubMedia());
        if (this.paramProperties.getPubsubMedia().equals((Object)PubsubMedia.NONE)) {
            return new ParamPubsubServiceNoneImpl();
        }
        if (this.paramProperties.getPubsubMedia().equals((Object)PubsubMedia.AMQP)) {
            return new ParamPubsubServiceAmqpImpl();
        }
        throw new ParamException(ErrorCode.PARAM_SYSTEM_ERROR, "\u53c2\u6570\u901a\u77e5\u5a92\u4ecb\u4e0d\u652f\u6301" + (Object)((Object)this.paramProperties.getPubsubMedia()));
    }

    @Bean
    public ParamStoreService paramStoreService() {
        log.info("Param Store Media: {}", (Object)this.paramProperties.getStoreMedia());
        if (this.paramProperties.getStoreMedia().equals((Object)StoreMedia.DATABASE)) {
            return new ParamStoreServiceDatabaseImpl();
        }
        throw new ParamException(ErrorCode.PARAM_SYSTEM_ERROR, "\u53c2\u6570\u5b58\u50a8\u5a92\u4ecb\u4e0d\u652f\u6301" + (Object)((Object)this.paramProperties.getStoreMedia()));
    }
}

