package org.krproject.ocean.vitamins.param.service.inner.provided;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;
import org.krproject.ocean.vitamins.param.service.inner.model.ParamModel;

import lombok.extern.slf4j.Slf4j;

/**
 * 参数访问服务-直接访问实现.
 * @author zhongyang
 *
 */
@Slf4j
public class ParamAccessServiceDirectImpl implements ParamAccessService {

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getParameter(String orgId, String paramClass, String key, ParamStoreService paramStoreService) {
		log.debug("getParameter with orgId:{}, paramClass:{}, key:{}", orgId, paramClass, key);
		
		ParamModel paramStoreModel = paramStoreService.getParamStore(orgId, paramClass, key);
		if (paramStoreModel != null) {
			return (T) paramStoreModel.getParamObject();
		}
		return null;
	}


	@SuppressWarnings("unchecked")
	@Override
	public <T> Map<String, T> getParameterMap(String orgId, String paramClass, ParamStoreService paramStoreService) {
		log.debug("getParameterMap with orgId:{}, paramClass:{}", orgId, paramClass);
		
		Map<String, T> paramMap = new HashMap<String, T>();
		List<ParamModel> listParamModel = paramStoreService.listParamStore(orgId, paramClass);
		if (listParamModel != null && listParamModel.size() > 0) {
			for (ParamModel paramStoreModel : listParamModel) {
				paramMap.put(paramStoreModel.getParamKey(), (T) paramStoreModel.getParamObject());
			}
		}
		return paramMap;
	}


	@Override
	public void onChangedParameter(String orgId, String paramClass, String key) {
		log.debug("onChangedParameter with orgId:{}, paramClass:{}, key:{}", orgId, paramClass, key);
		
	}
}
