package org.krproject.ocean.vitamins.param.service.inner.customize;

import java.lang.reflect.ParameterizedType;

import org.krproject.ocean.vitamins.param.service.inner.ParamAccessService;
import org.krproject.ocean.vitamins.param.service.inner.ParamPubsubService;
import org.krproject.ocean.vitamins.param.service.inner.ParamStoreService;

/**
 * 参数自定义抽象类.
 *
 * @param <T> 参数泛型
 * 
 * @author zhongyang
 */
public abstract class AbstractParamCustomize<T> implements ParamPubsubService, ParamAccessService, ParamStoreService {
	
	/**
	 * 获取参数类.
	 * @return 参数类
	 */
	@SuppressWarnings("unchecked")
	public Class<T> getParamClass() {
		Class<T> tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}

}
